/*
 * Decompiled with CFR 0.152.
 */
package de.berndbock.tinysvg;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Config {
    private static final Logger LOGGER = Logger.getLogger("global");
    private static final String CONFIGFILENAME = "TinySVG.properties";
    private static final String PROP_SVG_PATH = "svgPath";
    private static final String PROP_LOG_LEVEL = "logLevel";
    private static final String PROP_CENTER = "center";
    private static final String PROP_RESIZE = "resize";
    private static final String PROP_SCALE_FACTOR = "scaleFactor";
    private static final String PROP_OFFSET_X = "offsetX";
    private static final String PROP_OFFSET_Y = "offsetY";
    private static final String PROP_MIRROR_VERT = "mirrorVertically";
    private static final String PROP_MIRROR_HORIZ = "mirrorHorizontally";
    private static final String PROP_ROTATE_CLOCKWISE = "rotateClockwise";
    private static final String PROP_ORIGIN_BOTTOM_LEFT = "originAtBottomLeft";
    private static final String PROP_USE_BEZIER_CURVE_APPROXIMATION = "useBezierCurveApproximation";
    private static final String PROP_BEZIER_FACTOR = "bezierFactor";
    private static final String PROP_USE_ARC_APPROXIMATION = "useArcApproximation";
    private static final String PROP_LINE_REDUCER = "activateLineReducer";
    private static final String PROP_WRITE_VEC = "writeVecFile";
    private static final String PROP_WRITE_EGG_PAINTER = "writeEggPainterFile";
    private static final String PROP_WRITE_ZXCNC = "writeZxCncFile";
    private static final String PROP_WRITE_ZX81 = "writeZX81File";
    private static final String PROP_WRITE_ZX_SPECTRUM = "writeZXSpectrumFile";
    private static final String PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT = "writeZXSpectrumSpeedplotFile";
    private static final String PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT_EXT = "writeZXSpectrumSpeedplotExtFile";
    private static final String PROP_WRITE_HPGL = "writeHpglFile";
    private static final String PROP_WRITE_VE2 = "writeVe2File";
    private static final String PROP_WRITE_SVG = "writeSvgFile";
    private static final String PROP_PROFILE_FLAGS = "profileFlags";
    private static final String PROP_RESOLUTION_X = "resolutionX";
    private static final String PROP_RESOLUTION_Y = "resolutionY";
    private static final String PROP_DOUBLE_HEIGHT_PREVIEW = "doubleHeightPreview";
    private String svgPath;
    private Level logLevel;
    private boolean center;
    private boolean resize;
    private double scaleFactor;
    private double offsetX;
    private double offsetY;
    private boolean mirrorVertically;
    private boolean mirrorHorizontally;
    private double rotateClockwise;
    private boolean originAtBottomLeft;
    private boolean useBezierCurveApproximation;
    private int bezierFactor;
    private boolean useArcApproximation;
    private boolean activateLineReducer;
    private boolean writeVec;
    private boolean writeEggPainter;
    private boolean writeZxCnc;
    private boolean writeZX81;
    private boolean writeZXSpectrum;
    private boolean writeZXSpectrumSpeedplot;
    private boolean writeZXSpectrumSpeedplotExt;
    private boolean writeHpgl;
    private boolean writeVe2;
    private boolean writeSvg;
    private int profileFlags;
    private int resolutionX;
    private int resolutionY;
    private boolean doubleHeightPreview;
    private boolean cancelled;
    private double interimScaleFactor;

    public Config() {
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(CONFIGFILENAME));
            this.svgPath = prop.getProperty(PROP_SVG_PATH);
            String sProperty = prop.getProperty(PROP_LOG_LEVEL);
            this.logLevel = sProperty == null ? Level.WARNING : Level.parse(prop.getProperty(PROP_LOG_LEVEL));
            this.center = this.stringToBoolean(prop.getProperty(PROP_CENTER));
            this.resize = this.stringToBoolean(prop.getProperty(PROP_RESIZE));
            sProperty = prop.getProperty(PROP_SCALE_FACTOR);
            this.scaleFactor = sProperty == null ? 1.0 : this.stringToDouble(sProperty);
            sProperty = prop.getProperty(PROP_OFFSET_X);
            this.offsetX = sProperty == null ? 0.0 : this.stringToDouble(sProperty);
            sProperty = prop.getProperty(PROP_OFFSET_Y);
            this.offsetY = sProperty == null ? 0.0 : this.stringToDouble(sProperty);
            this.mirrorVertically = this.stringToBoolean(prop.getProperty(PROP_MIRROR_VERT));
            this.mirrorHorizontally = this.stringToBoolean(prop.getProperty(PROP_MIRROR_HORIZ));
            this.rotateClockwise = this.stringToDouble(prop.getProperty(PROP_ROTATE_CLOCKWISE));
            this.originAtBottomLeft = this.stringToBoolean(prop.getProperty(PROP_ORIGIN_BOTTOM_LEFT));
            this.useBezierCurveApproximation = this.stringToBoolean(prop.getProperty(PROP_USE_BEZIER_CURVE_APPROXIMATION));
            this.bezierFactor = this.stringToInt(prop.getProperty(PROP_BEZIER_FACTOR));
            this.useArcApproximation = this.stringToBoolean(prop.getProperty(PROP_USE_ARC_APPROXIMATION));
            if (this.bezierFactor == 0) {
                this.bezierFactor = 10;
            }
            this.activateLineReducer = this.stringToBoolean(prop.getProperty(PROP_LINE_REDUCER));
            this.writeVec = this.stringToBoolean(prop.getProperty(PROP_WRITE_VEC));
            this.writeEggPainter = this.stringToBoolean(prop.getProperty(PROP_WRITE_EGG_PAINTER));
            this.writeZxCnc = this.stringToBoolean(prop.getProperty(PROP_WRITE_ZXCNC));
            this.writeZX81 = this.stringToBoolean(prop.getProperty(PROP_WRITE_ZX81));
            this.writeZXSpectrum = this.stringToBoolean(prop.getProperty(PROP_WRITE_ZX_SPECTRUM));
            this.writeZXSpectrumSpeedplot = this.stringToBoolean(prop.getProperty(PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT));
            this.writeZXSpectrumSpeedplotExt = this.stringToBoolean(prop.getProperty(PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT_EXT));
            this.writeHpgl = this.stringToBoolean(prop.getProperty(PROP_WRITE_HPGL));
            this.writeVe2 = this.stringToBoolean(prop.getProperty(PROP_WRITE_VE2));
            this.writeSvg = this.stringToBoolean(prop.getProperty(PROP_WRITE_SVG));
            this.profileFlags = this.stringToInt(prop.getProperty(PROP_PROFILE_FLAGS));
            this.resolutionX = this.stringToInt(prop.getProperty(PROP_RESOLUTION_X));
            this.resolutionY = this.stringToInt(prop.getProperty(PROP_RESOLUTION_Y));
            this.doubleHeightPreview = this.stringToBoolean(prop.getProperty(PROP_DOUBLE_HEIGHT_PREVIEW));
        }
        catch (IOException ex) {
            this.svgPath = null;
            this.logLevel = Level.WARNING;
            this.center = false;
            this.resize = false;
            this.scaleFactor = 1.0;
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.mirrorVertically = false;
            this.mirrorHorizontally = false;
            this.rotateClockwise = 0.0;
            this.originAtBottomLeft = false;
            this.useBezierCurveApproximation = false;
            this.bezierFactor = 10;
            this.useArcApproximation = false;
            this.activateLineReducer = false;
            this.writeVec = false;
            this.writeEggPainter = false;
            this.writeZxCnc = false;
            this.writeZX81 = false;
            this.writeZXSpectrum = false;
            this.writeZXSpectrumSpeedplot = false;
            this.writeZXSpectrumSpeedplotExt = false;
            this.writeHpgl = false;
            this.writeVe2 = false;
            this.writeSvg = false;
            this.profileFlags = 511;
            this.resolutionX = 720;
            this.resolutionY = 256;
            this.doubleHeightPreview = true;
        }
        this.cancelled = false;
        this.interimScaleFactor = 1.0;
    }

    public String getSvgPath() {
        return this.svgPath;
    }

    public void setSvgPath(String svgPath) {
        this.svgPath = svgPath;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setCenter(boolean center) {
        this.center = center;
    }

    public boolean isResize() {
        return this.resize;
    }

    public void setResize(boolean resize) {
        this.resize = resize;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public double getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(double offsetX) {
        this.offsetX = offsetX;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(double offsetY) {
        this.offsetY = offsetY;
    }

    public boolean isMirrorVertically() {
        return this.mirrorVertically;
    }

    public void setMirrorVertically(boolean mirrorVertically) {
        this.mirrorVertically = mirrorVertically;
    }

    public boolean isMirrorHorizontally() {
        return this.mirrorHorizontally;
    }

    public void setMirrorHorizontally(boolean mirrorHorizontally) {
        this.mirrorHorizontally = mirrorHorizontally;
    }

    public double getRotateClockwise() {
        return this.rotateClockwise;
    }

    public void setRotateClockwise(double rotateClockwise) {
        this.rotateClockwise = rotateClockwise;
    }

    public boolean isOriginAtBottomLeft() {
        return this.originAtBottomLeft;
    }

    public void setOriginAtBottomLeft(boolean originAtBottomLeft) {
        this.originAtBottomLeft = originAtBottomLeft;
    }

    public boolean useBezierCurveApproximation() {
        return this.useBezierCurveApproximation;
    }

    public void setUseBezierCurveApproximation(boolean useBezierCurveApproximation) {
        this.useBezierCurveApproximation = useBezierCurveApproximation;
    }

    public boolean useArcApproximation() {
        return this.useArcApproximation;
    }

    public void setUseArcApproximation(boolean useArcApproximation) {
        this.useArcApproximation = useArcApproximation;
    }

    public int getBezierFactor() {
        return this.bezierFactor;
    }

    public void setBezierFactor(int bezierFactor) {
        this.bezierFactor = bezierFactor;
    }

    public boolean isLineReducerActivated() {
        return this.activateLineReducer;
    }

    public void setLineReducerActivated(boolean activateLineReducer) {
        this.activateLineReducer = activateLineReducer;
    }

    public boolean isWriteVec() {
        return this.writeVec;
    }

    public void setWriteVec(boolean writeVec) {
        this.writeVec = writeVec;
    }

    public boolean isWriteEggPainter() {
        return this.writeEggPainter;
    }

    public void setWriteEggPainter(boolean writeEggPainter) {
        this.writeEggPainter = writeEggPainter;
    }

    public boolean isWriteZxCnc() {
        return this.writeZxCnc;
    }

    public void setWriteZxCnc(boolean writeZxCnc) {
        this.writeZxCnc = writeZxCnc;
    }

    public boolean isWriteZX81() {
        return this.writeZX81;
    }

    public void setWriteZX81(boolean writeZX81) {
        this.writeZX81 = writeZX81;
    }

    public boolean isWriteZXSpectrum() {
        return this.writeZXSpectrum;
    }

    public void setWriteZXSpectrum(boolean writeZXSpectrum) {
        this.writeZXSpectrum = writeZXSpectrum;
    }

    public boolean isWriteZXSpectrumSpeedplot() {
        return this.writeZXSpectrumSpeedplot;
    }

    public void setWriteZXSpectrumSpeedplot(boolean writeZXSpectrumSpeedplot) {
        this.writeZXSpectrumSpeedplot = writeZXSpectrumSpeedplot;
    }

    public boolean isWriteZXSpectrumSpeedplotExt() {
        return this.writeZXSpectrumSpeedplotExt;
    }

    public void setWriteZXSpectrumSpeedplotExt(boolean writeZXSpectrumSpeedplotExt) {
        this.writeZXSpectrumSpeedplotExt = writeZXSpectrumSpeedplotExt;
    }

    public boolean isWriteHpgl() {
        return this.writeHpgl;
    }

    public void setWriteHpgl(boolean writeHpgl) {
        this.writeHpgl = writeHpgl;
    }

    public boolean isWriteVe2() {
        return this.writeVe2;
    }

    public void setWriteVe2(boolean writeVe2) {
        this.writeVe2 = writeVe2;
    }

    public boolean isWriteSvg() {
        return this.writeSvg;
    }

    public void setWriteSvg(boolean writeSvg) {
        this.writeSvg = writeSvg;
    }

    public int getProfileFlags() {
        return this.profileFlags;
    }

    public void setProfileFlags(int profileFlags) {
        this.profileFlags = profileFlags;
    }

    public int getResolutionX() {
        return this.resolutionX;
    }

    public void setResolutionX(int resolutionX) {
        this.resolutionX = resolutionX;
    }

    public int getResolutionY() {
        return this.resolutionY;
    }

    public boolean isDoubleHeightPreview() {
        return this.doubleHeightPreview;
    }

    public void setDoubleHeightPreview(boolean doubleHeightPreview) {
        this.doubleHeightPreview = doubleHeightPreview;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public double getInterimScaleFactor() {
        return this.interimScaleFactor;
    }

    public void setInterimScaleFactor(double interimScaleFactor) {
        this.interimScaleFactor = interimScaleFactor;
    }

    public int getResolutionYAdjusted() {
        if (this.doubleHeightPreview) {
            return this.resolutionY << 1;
        }
        return this.resolutionY;
    }

    public void setResolutionY(int resolutionY) {
        this.resolutionY = resolutionY;
    }

    public void save() {
        Properties prop = new Properties();
        try {
            prop.setProperty(PROP_SVG_PATH, this.svgPath);
            prop.setProperty(PROP_LOG_LEVEL, this.logLevel.toString());
            prop.setProperty(PROP_CENTER, this.booleanToString(this.center));
            prop.setProperty(PROP_RESIZE, this.booleanToString(this.resize));
            prop.setProperty(PROP_SCALE_FACTOR, this.doubleToString(this.scaleFactor));
            prop.setProperty(PROP_OFFSET_X, this.doubleToString(this.offsetX));
            prop.setProperty(PROP_OFFSET_Y, this.doubleToString(this.offsetY));
            prop.setProperty(PROP_MIRROR_VERT, this.booleanToString(this.mirrorVertically));
            prop.setProperty(PROP_MIRROR_HORIZ, this.booleanToString(this.mirrorHorizontally));
            prop.setProperty(PROP_ROTATE_CLOCKWISE, this.doubleToString(this.rotateClockwise));
            prop.setProperty(PROP_ORIGIN_BOTTOM_LEFT, this.booleanToString(this.originAtBottomLeft));
            prop.setProperty(PROP_USE_BEZIER_CURVE_APPROXIMATION, this.booleanToString(this.useBezierCurveApproximation));
            prop.setProperty(PROP_BEZIER_FACTOR, this.intToString(this.bezierFactor));
            prop.setProperty(PROP_USE_ARC_APPROXIMATION, this.booleanToString(this.useArcApproximation));
            prop.setProperty(PROP_LINE_REDUCER, this.booleanToString(this.activateLineReducer));
            prop.setProperty(PROP_WRITE_VEC, this.booleanToString(this.writeVec));
            prop.setProperty(PROP_WRITE_EGG_PAINTER, this.booleanToString(this.writeEggPainter));
            prop.setProperty(PROP_WRITE_ZXCNC, this.booleanToString(this.writeZxCnc));
            prop.setProperty(PROP_WRITE_ZX81, this.booleanToString(this.writeZX81));
            prop.setProperty(PROP_WRITE_ZX_SPECTRUM, this.booleanToString(this.writeZXSpectrum));
            prop.setProperty(PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT, this.booleanToString(this.writeZXSpectrumSpeedplot));
            prop.setProperty(PROP_WRITE_ZX_SPECTRUM_SPEEDPLOT_EXT, this.booleanToString(this.writeZXSpectrumSpeedplotExt));
            prop.setProperty(PROP_WRITE_HPGL, this.booleanToString(this.writeHpgl));
            prop.setProperty(PROP_WRITE_VE2, this.booleanToString(this.writeVe2));
            prop.setProperty(PROP_WRITE_SVG, this.booleanToString(this.writeSvg));
            prop.setProperty(PROP_PROFILE_FLAGS, this.intToString(this.profileFlags));
            prop.setProperty(PROP_RESOLUTION_X, this.intToString(this.resolutionX));
            prop.setProperty(PROP_RESOLUTION_Y, this.intToString(this.resolutionY));
            prop.setProperty(PROP_DOUBLE_HEIGHT_PREVIEW, this.booleanToString(this.doubleHeightPreview));
            prop.store(new FileOutputStream(CONFIGFILENAME), "TinySVG options");
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
    }

    private boolean stringToBoolean(String s) {
        return Boolean.valueOf(s);
    }

    private String booleanToString(boolean b) {
        return String.valueOf(b);
    }

    private int stringToInt(String s) {
        int i;
        try {
            i = Integer.valueOf(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            i = 0;
        }
        return i;
    }

    private String intToString(int i) {
        return String.valueOf(i);
    }

    private double stringToDouble(String s) {
        double d;
        try {
            d = Double.valueOf(s);
        }
        catch (NullPointerException | NumberFormatException e) {
            d = 0.0;
        }
        return d;
    }

    private String doubleToString(double d) {
        return String.valueOf(d);
    }
}

