(* PBM Reader - reads PBM files and displays them on the screen. *)
(* Version 3.1 *)
program PbmReader;
(*$IKERNEL.INC*)
(*$IGRAPHLIB.INC*)
(*$IINPUT.INC*)
(*$IBOX.INC*)
(*$ISCREEN.INC*)
(*$IPBMIN.INC*)

label
  byebye;
var
  FileName: string(.14.);
  err:      ErrorCode;
  invert:   boolean;
  ch:       char;
  
  
  (* Inverts the screen in memory, i.e. without reading the file again. *)
  procedure InvertInMemory;
  var
    row: byte;
    i: integer;
  begin
    for row := 0 to 31 do begin
      GetScreenRow(row);
      for i := 0 to 719 do begin
        GX_Buffer(.i.) := GX_Buffer(.i.) xor $FF;
      end;
      PutScreenRow(row);
    end;
  end; (* InvertInMemory *)

(* Main program *)
begin
  ClrScr;
  invert := false;
  
  (* get the name of the PBM file *)
  if ParamCount > 0 then begin
    FileName := ParamStr(1); (* first commandline parameter treated as filename *)
    if ParamCount > 1 then begin
      if ParamStr(2) = 'INVERT' then invert := true;
    end;
  end
  else begin
    DrawBox(1, 1, 90, 3);
    GotoXY(28, 2);
    Write('PBM file reader V3.1 by Bernd Bock');
    DrawBox(1, 4, 90, 3);
    GotoXY(3, 5);
    Write('Enter name of PBM file: ');
    FileName := InputFileName;
    GotoXY(1, 7);
    if Length(FileName) = 0 then goto byebye; (* abort if no filename entered *)
    Write('Invert the picture? (Y/N) ');
    ch := InputChar;
    if (ch = 'Y') or (ch = 'y') then invert := true;
  end;
  
  GraphInit;
  HideCursor;

  err := LoadScreenFromPBM(FileName, invert);
  if err <> ErrOk then begin
    WriteLn;
    case err of
      ErrFileNotFound:       WriteLn('File not found: ', FileName);
      ErrFormatNotSupported: WriteLn('Format not supported: only 720x256 or 720x512 binary - PBM type 4')
      else                   WriteLn('Unknown error!');
    end;
    WriteKeyMessage;
  end
  else
    repeat
      ch := InputCharNoEcho;
      if ch = 'i' then ch := 'I';            (* 'I' input always uppercase *)
      if ch = 'I' then InvertInMemory;
    until ch <> 'I';
  
byebye:  
  Write(chr(27), '0'); (* switch off status bar *)
  ClrScr;              (* now clears the status bar, too *)
  Write(chr(27), '1'); (* switch on status bar *)
  ShowCursor;
end.
