(* ------------------- SCREEN.INC ----------------------

  Include file to get and put screen pixel data.
  Provides the following functions:

    procedure GetScreenRow -> Get image row from the Roller RAM
    procedure PutScreenRow -> Put image row to the Roller RAM

  Uses include file KERNEL.INC.

  ---------------------------------------------------- *)

type GX_Buffer_Type = array(.0..719.) of byte;
var  GX_Buffer : GX_Buffer_Type;


(* Gets a row of screen pixel data from the roller RAM and writes it
   to the GX_Buffer.
   row may range from 0 to 31. *)
procedure GetScreenRow(row: byte);
var
    i, j   : integer;
    RowMC  : byte absolute $F29C;
    ColMC  : byte absolute $F29A;
    AccMode: byte absolute $F2B5;
    Matrix : array(.0..7.) of byte absolute $F273;
begin
    j:=0;
    AccMode:=0;
    RowMC:=row;
    for ColMC:=0 to 89 do begin
        GX_ScrAcc;
        for i:=0 to 7 do begin
            GX_Buffer(.j.):=Matrix(.i.);
            j:=succ(j);
        end;
    end;
end;

(* Puts a row of screen pixel data from the GX_Buffer to the
   screen roller RAM.
   row may range from 0 to 31. *)
procedure PutScreenRow(row: byte);
var
    i, j   : integer;
    RowMC  : byte absolute $F29C;
    ColMC  : byte absolute $F29A;
    AccMode: byte absolute $F2B5;
    Matrix : array(.0..7.) of byte absolute $F273;
begin
    j:=0;
    AccMode:=1;
    RowMC:=row;
    for ColMC:=0 to 89 do begin
        for i:=0 to 7 do begin
            Matrix(.i.):=GX_Buffer(.j.);
            j:=succ(j);
        end;
        GX_ScrAcc;
    end;
end;

(* Clears a screen row.
   row may range from 0 to 31. *)
procedure ClearScreenRow(row: byte);
var
    i      : integer;
    RowMC  : byte absolute $F29C;
    ColMC  : byte absolute $F29A;
    AccMode: byte absolute $F2B5;
    Matrix : array(.0..7.) of byte absolute $F273;
begin
    AccMode:=1;
    RowMC:=row;
    for i:=0 to 7 do begin
        Matrix(.i.):=0;
    end;
    for ColMC:=0 to 89 do begin
        GX_ScrAcc;
    end;
end;

(* --------------- End of SCREEN.INC ------------------- *)
