(* ------------------------- KERNEL2.INC ----------------------------- *)
(*  Include-File fuer Grafikbefehle auf der JOYCE unter Turbo Pascal.  *)
(*  Hauptmodul, enthaelt MCode und elementare Routinen. Muss auf alle  *)
(*  Faelle ins Hauptprogramm eingebunden werden.                       *)
(*  Es sind enthalten:                                                 *)
(*                                                                     *)
(*     procedure GraphInit           -> Initialisierung des MCode      *)
(*     procedure Plot(x,y,m)         -> Pixel set/reset/invert         *)
(*     procedure Line(x0,y0,x1,y1,m) -> Linie zeichnen                 *)
(*     procedure Screen_On           -> Bildschirm einschalten         *)
(*     procedure Screen_Off          -> Bildschirm ausschalten         *)
(*     procedure ShowCursor          -> Cursor ein                     *)
(*     procedure HideCursor          -> Cursor aus                     *)
(*     function  DotColor()          -> TRUE=Pixel gesetzt             *)
(*     procedure Symbol              -> Zeichensatz aendern            *)
(*     procedure Hex_Symbol          -> Zeichensatz aendern            *)
(*                                                                     *)
(*   Variablen & Prozeduren mit dem Namen GX_ sind zu vermeiden, um    *)
(*   nicht mit Interna der Grafikerweiterungen zu kollidieren.         *)
(*                                                                     *)
(*   Zum Compilieren die Endadresse auf $EFFF setzen, um nicht den     *)
(*   MCode zu ueberschreiben!                                          *)
(* ------------------------------------------------------------------- *)

type GX_MCode  = array(.0..548.) of byte;
     GX_String = string(.8.);

var  GX_MProg: GX_MCode absolute $F200;

const GX_Data:GX_MCode =
  ($01,$09,$F2,$CD,$5A,$FC,$E9,$00,$C9,$ED,$5B,$C7,$F2,$2A,$C9,$F2,
   $3E,$03,$A2,$57,$E5,$26,$00,$29,$01,$00,$B6,$09,$4E,$23,$46,$79,
   $E6,$F8,$6F,$60,$29,$19,$7D,$E6,$F8,$6F,$79,$E6,$07,$B5,$6F,$7B,
   $E6,$07,$3C,$47,$AF,$37,$1F,$10,$FD,$C1,$4F,$78,$FE,$00,$20,$04,
   $79,$B6,$77,$C9,$FE,$01,$20,$05,$79,$2F,$A6,$77,$C9,$FE,$02,$20,
   $04,$79,$AE,$77,$C9,$FE,$03,$C0,$79,$A6,$32,$CB,$F2,$C9,$01,$67,
   $F2,$CD,$5A,$FC,$E9,$00,$C9,$21,$73,$F2,$01,$08,$00,$11,$00,$00,
   $ED,$B0,$C9,$00,$00,$00,$00,$00,$00,$00,$00,$01,$84,$F2,$CD,$5A,
   $FC,$E9,$00,$C9,$21,$00,$00,$01,$08,$00,$11,$73,$F2,$ED,$B0,$C9,
   $01,$99,$F2,$CD,$5A,$FC,$E9,$00,$C9,$1E,$00,$3E,$00,$16,$00,$07,
   $17,$17,$17,$6F,$7A,$CE,$B6,$67,$7E,$23,$66,$6F,$EB,$29,$29,$19,
   $29,$01,$08,$00,$3E,$00,$FE,$00,$20,$06,$11,$73,$F2,$ED,$B0,$C9,
   $EB,$21,$73,$F2,$ED,$B0,$C9,$00,$00,$00,$00,$00,$00,$00,$00,$00,
   $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,
   $00,$00,$01,$EB,$F2,$CD,$5A,$FC,$E9,$00,$C9,$ED,$5B,$CC,$F2,$ED,
   $53,$D0,$F2,$2A,$CC,$F2,$ED,$5B,$C7,$F2,$B7,$ED,$52,$22,$D4,$F2,
   $ED,$5B,$CE,$F2,$ED,$53,$D2,$F2,$2A,$CE,$F2,$ED,$5B,$C9,$F2,$B7,
   $ED,$52,$22,$D6,$F2,$21,$01,$00,$22,$DE,$F2,$22,$E0,$F2,$3A,$D5,
   $F2,$CB,$7F,$28,$13,$21,$FF,$FF,$22,$DE,$F2,$21,$00,$00,$ED,$5B,
   $D4,$F2,$B7,$ED,$52,$22,$D4,$F2,$3A,$D7,$F2,$CB,$7F,$28,$13,$21,
   $FF,$FF,$22,$E0,$F2,$21,$00,$00,$ED,$5B,$D6,$F2,$B7,$ED,$52,$22,
   $D6,$F2,$2A,$D4,$F2,$29,$22,$D8,$F2,$2A,$D6,$F2,$29,$22,$DA,$F2,
   $2A,$D6,$F2,$ED,$5B,$D4,$F2,$13,$B7,$ED,$52,$38,$03,$C3,$CA,$F3,
   $ED,$5B,$D4,$F2,$21,$00,$00,$B7,$ED,$52,$22,$DC,$F2,$2A,$C7,$F2,
   $ED,$5B,$D0,$F2,$B7,$ED,$52,$7C,$B5,$28,$3C,$CD,$09,$F2,$ED,$5B,
   $DC,$F2,$2A,$DA,$F2,$19,$22,$DC,$F2,$CB,$7C,$20,$1C,$7C,$B5,$28,
   $18,$2A,$DC,$F2,$ED,$5B,$D8,$F2,$B7,$ED,$52,$22,$DC,$F2,$2A,$C9,
   $F2,$ED,$5B,$E0,$F2,$19,$22,$C9,$F2,$2A,$C7,$F2,$ED,$5B,$DE,$F2,
   $19,$22,$C7,$F2,$C3,$7D,$F3,$C3,$21,$F4,$21,$00,$00,$ED,$5B,$D6,
   $F2,$B7,$ED,$52,$22,$DC,$F2,$2A,$C9,$F2,$ED,$5B,$D2,$F2,$B7,$ED,
   $52,$7C,$B5,$28,$3C,$CD,$09,$F2,$2A,$DC,$F2,$ED,$5B,$D8,$F2,$19,
   $22,$DC,$F2,$CB,$7C,$20,$1C,$7D,$B4,$28,$18,$2A,$DC,$F2,$ED,$5B,
   $DA,$F2,$B7,$ED,$52,$22,$DC,$F2,$2A,$C7,$F2,$ED,$5B,$DE,$F2,$19,
   $22,$C7,$F2,$2A,$C9,$F2,$ED,$5B,$E0,$F2,$19,$22,$C9,$F2,$C3,$D7,
   $F3,$CD,$09,$F2,$C9);


PROCEDURE GX_Dot; external $F200;

PROCEDURE GX_Symb; external $F25E;

PROCEDURE GX_Get; external $F27B;

PROCEDURE GX_ScrAcc; external $F290;

PROCEDURE GX_Line; external $F2E2;


PROCEDURE GraphInit;
begin
  GX_MProg:=GX_Data;
end;


PROCEDURE Plot(x: integer; y, m: byte);
var  GX_X: integer absolute $F2C7;
     GX_Y: byte    absolute $F2C9;
     GX_M: byte    absolute $F2CB;
begin
  GX_X:=x;
  GX_Y:=y;
  GX_M:=m;
  GX_Dot;
end;

PROCEDURE Line(x0, y0, x1, y1: integer; m: byte);
var  GX_X0: integer absolute $F2C7;
     GX_Y0: integer absolute $F2C9;
     GX_M:  byte    absolute $F2CB;
     GX_X1: integer absolute $F2CC;
     GX_Y1: integer absolute $F2CE;
begin
  GX_X0:=x0;
  GX_Y0:=y0;
  GX_X1:=x1;
  GX_Y1:=y1;
  GX_M:=m;
  GX_Line;
end;

FUNCTION DotColor (x: integer; y: byte): boolean;
begin
  Plot(x,y,3);
  DotColor:=mem(.$F2CB.) <> 0; (* MODE in MC*)
end;


PROCEDURE Screen_On;
begin
  port(.248.):=7;
end;

PROCEDURE Screen_Off;
begin
  port(.248.):=8;
end;

PROCEDURE HideCursor;
begin
 write(#27,'f');
end;

PROCEDURE ShowCursor;
begin
  write(#27,'e');
end;


FUNCTION GX_Convert(var rowpic:GX_String):byte;
var  i,j : byte;
begin
  if length(rowpic)<8 then
    for i:=succ(length(rowpic)) to 8 do rowpic:=rowpic+' ';
  j:=0;
  for i:=1 to 8 do begin
    j:=j shl 1;
    if rowpic(.i.)='*' then j:=succ(j)
  end;
  GX_Convert:=j
end;


PROCEDURE Symbol(Code:byte; rp0,rp1,rp2,rp3,rp4,rp5,rp6,rp7:GX_String);
var   matrix : array(.0..7.) of byte absolute $F273;
      CStart : integer absolute $F26E;
begin
  matrix(.0.):=GX_Convert(rp0);
  matrix(.1.):=GX_Convert(rp1);
  matrix(.2.):=GX_Convert(rp2);
  matrix(.3.):=GX_Convert(rp3);
  matrix(.4.):=GX_Convert(rp4);
  matrix(.5.):=GX_Convert(rp5);
  matrix(.6.):=GX_Convert(rp6);
  matrix(.7.):=GX_Convert(rp7);
  CStart:=Code*8+$B800;
  GX_Symb;
end;


PROCEDURE Hex_Symbol(Code,r0,r1,r2,r3,r4,r5,r6,r7:byte);
var   matrix : array(.0..7.) of byte absolute $F273;
      CStart : integer absolute $F26E;
begin
  matrix(.0.):=r0;
  matrix(.1.):=r1;
  matrix(.2.):=r2;
  matrix(.3.):=r3;
  matrix(.4.):=r4;
  matrix(.5.):=r5;
  matrix(.6.):=r6;
  matrix(.7.):=r7;
  CStart:=Code*8+$B800;
  GX_Symb;
end;

(* ------------------ Ende von KERNEL2.INC ---------------------- *)
