procedure Level_holen;
{Level des Spieles bestimmen}
begin
  clrscr;
  Video_String(29,10,Video_Attribut(Invers)+Video_Attribut(Breit)+Video_Attribut(Dick),'   L e v e l :   ');
  Video_String(34,13,Video_Attribut(Breit),'  langsam   ');
  Video_String(34,15,Video_Attribut(Breit),'   mittel   ');
  Video_String(34,17,Video_Attribut(Breit),'  schnell   ');
  repeat
    read(kbd,Auswahl);
  until (Auswahl in ['l','m','s',esc]);
  case Auswahl of
    'l': Ebene:=1;
    'm': Ebene:=2;
    's': Ebene:=3;
  end;
  Stand:=0;
  if (Auswahl=esc) then History_Datei_erstellen;
end;

procedure Spiel_Init;
{Spiel Initialisieren}
var
  j            : byte;
  i            : byte;
begin
  randomize;
  FranksRichtung:=FrankRechts;
  Einmal:=1;
  StandZahl:=1;
  FeldZahl:=1;
  LaufZahl:=1;
  WandZeichen:=random(3)*2+Wand;
  FruchtZahl:=0;
  Gewinner:=Niemand;
  StandWert:=Ebene*8;
  for j:=0 to BordReihen do
    for i:=0 to BordSpalten do Spielfeld[i,j]:=Wand2;
  for j:=1 to BordReihen-1 do
    for i:=1 to BordSpalten-1 do Spielfeld[i,j]:=Wand1;
  SpielX:=random(BordSpalten-10)+7;
  SpielY:=random(BordReihen-9)+5;
  for i:=2 to 11 do Spielfeld[SpielX,i]:=Leer;
  for j:=2 to 15 do Spielfeld[j,SpielY]:=Leer;
  for j:=1 to Ebene*5 do
  begin
    repeat
      XPos:=random(BordSpalten-3)+2;
      YPos:=random(BordReihen-3)+2;
    until (Spielfeld[XPos,YPos]=Wand1) and (Spielfeld[XPos,succ(YPos)]<>Leer);
    Spielfeld[XPos,YPos]:=Apfel;
  end;
  for j:=1 to StandWert do
    case random(10) of
      1 : begin
            repeat
              XPos:=random(BordSpalten-3)+2;
              YPos:=random(BordReihen-3)+2;
            until (Spielfeld[XPos,YPos]=Wand1) and (Spielfeld[XPos,pred(YPos)]=Apfel);
            Spielfeld[XPos,YPos]:=Birne;
          end;
     2,3: begin
            repeat
              XPos:=random(BordSpalten-3)+2;
              YPos:=random(BordReihen-3)+2;
            until (Spielfeld[XPos,YPos]=Wand1);
            Spielfeld[XPos,YPos]:=Banane;
          end;
     else begin
            repeat
              XPos:=random(BordSpalten-3)+2;
              YPos:=random(BordReihen-3)+2;
            until (Spielfeld[XPos,YPos]=Wand1);
            Spielfeld[XPos,YPos]:=Kirsche;
          end;
     end;
  for j:=1 to 3 do
  begin
    Aufstellung[1,j]:=0;
    Aufstellung[2,j]:=0;
  end;
  repeat
    XPos:=random(BordSpalten)+1;
    YPos:=random(BordReihen)+1;
  until (Spielfeld[XPos,YPos]=Leer) and not ((XPos=SpielX) and (YPos=SpielY));
end;

procedure Apfelzug;
var
  i            : byte;
begin
  for i:=1 to 3 do
  begin
    if (Spielfeld[Aufstellung[1,i],Aufstellung[2,i]]=Apfel) then
    begin
      SetzeFrucht(Aufstellung[1,i],Aufstellung[2,i]);
      Aufstellung[1,i]:=0;
      Stand:=succ(Stand);
    end;
    if ((Aufstellung[1,i]=XPos) and (Aufstellung[2,i]=YPos)) then Gewinner:=Kobold;
  end;
end;

procedure SetzeFigur(StandWahl:byte);
var
  XWahl        : byte;
  YWahl        : byte;
begin
  if   ((pred(Aufstellung[1,StandWahl])=XPos) and (Aufstellung[2,StandWahl]=YPos) and (FranksRichtung=FrankFaelltLinks))
    or ((succ(Aufstellung[1,StandWahl])=XPos) and (Aufstellung[2,StandWahl]=YPos) and (FranksRichtung=FrankFaelltRechts)) then
  begin
    SetzeFrucht(Aufstellung[1,StandWahl],Aufstellung[2,StandWahl]);
    Aufstellung[1,StandWahl]:=0;
    Stand:=succ(Stand);
  end;
  if (Aufstellung[1,StandWahl]=0) then
  else
  begin
    XWahl:=Aufstellung[1,StandWahl]+Bewegung[1,StandWahl];
    YWahl:=Aufstellung[2,StandWahl]+Bewegung[2,StandWahl];
    if ((Spielfeld[XWahl,YWahl]<>Leer) or (LaufZahl=1)) then
    begin
      Wichtung[StandWahl]:=3-Wichtung[StandWahl];
      if (Wichtung[StandWahl]=1) then
      begin
        Bewegung[2,StandWahl]:=0;
        if (Aufstellung[1,StandWahl]<XPos) then Bewegung[1,StandWahl]:= 1
                                           else Bewegung[1,StandWahl]:=-1;
        if (Spielfeld[Aufstellung[1,StandWahl]+Bewegung[1,StandWahl],Aufstellung[2,StandWahl]]<>Leer) then
           Bewegung[1,StandWahl]:=pred(random(3));
      end else
      begin
        Bewegung[1,StandWahl]:=0;
        if (Aufstellung[2,StandWahl]<YPos) then Bewegung[2,StandWahl]:= 1
                                           else Bewegung[2,StandWahl]:=-1;
        if (Spielfeld[Aufstellung[1,StandWahl],Aufstellung[2,StandWahl]+Bewegung[2,StandWahl]]<>Leer) then
           Bewegung[2,StandWahl]:=pred(random(3));
      end;
    end;
    SetzeFrucht(Aufstellung[1,StandWahl],Aufstellung[2,StandWahl]);
    if (Spielfeld [Aufstellung[1,StandWahl]+Bewegung[1,StandWahl],Aufstellung[2,StandWahl]+Bewegung[2,StandWahl]]=Leer) then
    begin
      Aufstellung[1,StandWahl]:=Aufstellung[1,StandWahl]+Bewegung[1,StandWahl];
      Aufstellung[2,StandWahl]:=Aufstellung[2,StandWahl]+Bewegung[2,StandWahl];
    end;
    SetzeKobold(Aufstellung[1,StandWahl],Aufstellung[2,StandWahl],Bewegung[1,StandWahl]);
  end;
end;

procedure HoleSpielbewegung;
var
  i            : byte;
begin
  for i:=1 to 3 do
  begin
    if (Aufstellung[1,i]=0) then
    begin
      Aufstellung[1,i]:=SpielX;
      Aufstellung[2,i]:=SpielY;
      Bewegung[1,i]:=0;
      if (random(2)=0) then Bewegung[2,i]:= 1
                       else Bewegung[2,i]:=-1;
      Wichtung[i]:=1;
      exit;
    end;
  end;
end;

procedure Frucht_Positionieren;
{Fruechte positionieren}
var
  PosX         : byte;
  PosY         : byte;
begin
  clrscr;
  for PosX:=BordSpalten DIV 2 downto 0 do
    for PosY:=BordReihen DIV 2 downto 0 do
    begin
      SetzeFrucht(PosX,PosY);
      SetzeFrucht(PosX,BordReihen-PosY);
      SetzeFrucht(BordSpalten-PosX,PosY);
      SetzeFrucht(BordSpalten-PosX,BordReihen-PosY);
    end;
end;

procedure Fix_Board;
{Spielfeld bearbeiten}
var
  ZahlZeichen  : string[5];
  i            : byte;
  j            : byte;
  Xrnd         : byte;
begin
  for i:=1 to pred(BordSpalten) do
    for j:=pred(BordReihen) downto 1 do
    begin
      if (Spielfeld[i,j]=Apfel) then
      begin
        if not ((i=XKopie) and (succ(j)=YKopie)) and
               ((Spielfeld[i,succ(j)]=Leer) or (Spielfeld[i,succ(j)]=Kuerbis)) then
        begin
          if (Spielfeld[i,succ(j)]=Kuerbis) then Stand:=Stand+10;
          Spielfeld[i,j]:=Leer;
          Spielfeld[i,succ(j)]:=Apfel;
          SetzeFrucht(i,succ(j));
          SetzeFrucht(i,j);
        end;
      end;
      if (Spielfeld[i,j]=Kuerbis) and not ((i=XKopie) and (succ(j)=YKopie)) then
      begin
        if (Spielfeld[i,succ(j)] in [Leer,Wand1]) then
        begin
          Spielfeld[i,j]:=Leer;
          Spielfeld[i,succ(j)]:=Kuerbis;
          SetzeKuerbis(i,succ(j));
          SetzeFrucht(i,j);
          Klingel;
        end else
        begin
          if (succ(j)>pred(BordReihen)) then
          begin
            Spielfeld[i,j]:=Leer;
            SetzeFrucht(i,j);
          end;
        end;
      end;
    end;
  Apfelzug;
  if (random(150)=0) then
  begin
    Xrnd:=random(BordSpalten-5)+2;
    if (Xrnd<>XPos) then
    begin
      Spielfeld[Xrnd,1]:=Kuerbis;
      SetzeKuerbis(Xrnd,1);
      Klingel;
    end;
  end;
  FeldZahl:=0;
  XKopie:=0;
  YKopie:=0;
  str(Stand:0,ZahlZeichen);
  Video_String(66,30,BreitBit,ZahlZeichen);
  if (Spielfeld[XPos,YPos] in [Apfel,Kuerbis]) then Gewinner:=Kobold;
  if (FruchtZahl=StandWert) then Gewinner:=Frank;
end;

procedure Spielen;
{Das Spiel ausfuehren}
begin
  StandZahl:=0;
  LaufZahl:=1;
  for i:=1 to 3 do Wichtung[i]:=random(2)+1;
  Video_String(12,30,BreitBit,'Level: ');
  case Ebene of
    1: Video_String(26,30,BreitBit,'langsam');
    2: Video_String(26,30,BreitBit,'mittel ');
    3: Video_String(26,30,BreitBit,'schnell');
  end;
  Video_String(48,30,BreitBit,'Punkte: ');
  while keypressed do read(kbd,Auswahl);
  SetzeFrank;
  repeat
    StandZahl:=succ(StandZahl);
    if (StandZahl>12-Ebene) then
    begin
      StandZahl:=1;
      LaufZahl:=succ(LaufZahl);
      if (LaufZahl=4) then LaufZahl:=1;
    end;
    if keypressed then
    begin
      read(kbd,Auswahl);
      if Auswahl in [cul,cur,cup,cud,cr,esc{++},warten{--}] then
      begin
        SetzeFrucht(XPos,YPos);
        case Auswahl of
          cr:  begin {Enter}
                 case FranksRichtung of
                   FrankLinks:
                      begin
                        FranksRichtung:=FrankFaelltRechts;
                        if (Spielfeld[pred(XPos),YPos]=Kuerbis) then
                        begin
                          Spielfeld[pred(XPos),YPos]:=Leer;
                          Stand:=Stand+10;
                          SetzeFrucht(pred(XPos),YPos);
                        end;
                      end;
                   FrankRechts:
                      begin
                        FranksRichtung:=FrankFaelltLinks;
                        if (Spielfeld[succ(XPos),YPos]=Kuerbis) then
                        begin
                          Spielfeld[succ(XPos),YPos]:=Leer;
                          Stand:=Stand+10;
                          SetzeFrucht(succ(XPos),YPos);
                        end;
                      end;
                 end;
               end;
          cul: begin {Cursor links}
                 if (Spielfeld[pred(XPos),YPos]<>Wand2) then
                 begin
                   XPos:=pred(XPos);
                   FranksRichtung:=FrankLinks;
                   if (Spielfeld[XPos,YPos]=Apfel) then
                   begin
                     if (Spielfeld[pred(XPos),YPos] in [Leer,Wand1,Kuerbis]) then
                     begin
                       Spielfeld[pred(XPos),YPos]:=Apfel;
                       SetzeFrucht(pred(XPos),YPos);
                     end else XPos:=succ(XPos);
                   end;
                   Apfelzug;
                 end;
               end;
          cur: begin {Cursor rechts}
                 if (Spielfeld[succ(XPos),YPos]<>Wand2) then
                 begin
                   XPos:=succ(XPos);
                   FranksRichtung:=FrankRechts;
                   if (Spielfeld[XPos,YPos]=Apfel) then
                   begin
                     if (Spielfeld[succ(XPos),YPos] in [Leer,Wand1,Kuerbis]) then
                     begin
                       Spielfeld[succ(XPos),YPos]:=Apfel;
                       SetzeFrucht(succ(XPos),YPos);
                     end else XPos:=pred(XPos);
                   end;
                   Apfelzug;
                 end;
               end;
          cud: begin {Cursor runter}
                 if (Spielfeld[XPos,succ(YPos)] in [Leer,Wand1,Kirsche,Banane,Birne,Kuerbis]) then
                 begin
                   YPos:=succ(YPos);
                   FranksRichtung:=FrankGerade;
                 end;
               end;
          cup: begin {Cursor hoch}
                 if (Spielfeld[XPos,pred(YPos)] in [Leer,Wand1,Kirsche,Banane,Birne,Kuerbis]) then
                 begin
                   YPos:=pred(YPos);
                   FranksRichtung:=FrankGerade;
                 end;
               end;
          esc: begin {ESCape}
                 Gewinner:=Kobold;
               end;
          {++}
          warten:repeat until keypressed;
          {--}
        end;
        SetzeFrank;
        case Spielfeld[XPos,YPos] of
         Kirsche:  begin
                     FruchtZahl:=succ(FruchtZahl);
                     Stand:=Stand+2;
                   end;
          Banane:  begin
                     FruchtZahl:=succ(FruchtZahl);
                     Stand:=Stand+3;
                   end;
           Birne:  begin
                     FruchtZahl:=succ(FruchtZahl);
                     Stand:=Stand+4;
                   end;
         Kuerbis: Gewinner:=Kobold;
        end;
        Spielfeld[XPos,YPos]:=Leer;
        XKopie:=XPos;
        YKopie:=YPos;
      end;
    end;
      if (StandZahl<4) then SetzeFigur(StandZahl);
      FeldZahl:=succ(FeldZahl);
      if (FeldZahl=5) then Fix_Board;
      if (random(70)=0) then HoleSpielbewegung;
  until (Gewinner<>Niemand);
end;

procedure Spielstand_ausgeben;
var
  modified     : boolean;
  wrkstr       : NameString;
  wp           : byte;

  procedure Stand_anzeigen;
  begin
    for wp:=1 to StandLaenge do
    begin
      if (SpielerStand[wp]>0) then
      begin
        str(wp:0,wrkstr);
        Video_String(1,6+wp,BreitBit,wrkstr);
        Video_String(BordSpalten,6+wp,BreitBit,SpielerName[wp]);
        str(SpielerStand[wp]:0,wrkstr);
        Video_String(57,6+wp,BreitBit,wrkstr);
      end;
    end;
  end;

begin {Spielstand_ausgeben}
  Cursor_An;
  clrscr;
  while keypressed do read(kbd,Auswahl);
  Video_String(27,2,Video_Attribut(Hoch)+Video_Attribut(Breit),'H I G H - S C O R E');
  Video_String(1,4,Video_Attribut(Breit)+Video_Attribut(Invers),'Nr.:     Name:             Punkte:          ');
  Stand_anzeigen;
  str(Stand:0,wrkstr);
  Video_String(1,26,Video_Attribut(Breit),concat('Punkte: ',wrkstr));
  Video_String(1,27,Video_Attribut(Breit),'Name: ');
  buflen:=20;
  gotoxy(13,27);
  read(ArbeitsFeld);
  for wp:=1 to length(ArbeitsFeld) do ArbeitsFeld[wp]:=upcase(ArbeitsFeld[wp]);
  ArbeitsFeld:=concat(ArbeitsFeld,'                    ');
  if (copy(ArbeitsFeld,1,5)='     ') then Cursor_Aus
  else
  begin
    modified:=false;
    for wp:=1 to StandLaenge do
    begin
      if (SpielerName[wp]=ArbeitsFeld) then
      begin
        if (SpielerStand[wp]<Stand) then SpielerStand[wp]:=Stand;
        modified:=true;
      end;
    end;
    for wp:=1 to StandLaenge do
    begin
      if ((SpielerStand[wp]=0) and not modified) then
      begin
        SpielerName[wp]:=ArbeitsFeld;
        SpielerStand[wp]:=Stand;
        modified:=true;
      end;
    end;
    if (not modified) then Video_String(1,28,Video_Attribut(Breit),'Liste ist voll !!!');
    Stand_anzeigen;
    Cursor_Aus;
    repeat until keypressed;
  end;
end;

