const
  cr           = #$0d;
  esc          = #$1b;
  cul          = 'a' {#1};
  cur          = 'r' {#6};
  cud          = 'y' {#30};
  cup          = 'w' {#31};
  warten       = ' ';

  BordSpalten  = 19;
  BordReihen   = 13;
  StandName    = 'fruit.his';
  LeerName     = '                     ';
  StandLaenge  = 15;

  StatusAn     = #$1b'1';
  StatusAus    = #$1b'0';
  CursorAn     = #$1b'e';
  CursorAus    = #$1b'f';

  SchirmDunkel = #$1b'b'#63#$1b'c'#0;
  SchirmHell   = #$1b'b'#0#$1b'c'#63;

  CHARMTX      = $B800;
  MtxAdr1      = $F310;
  MtxAdr2      = $F311;
  MtxZeile1    = $F315;
  MtxZeile2    = $F316;
  MtxZeile3    = $F317;
  MtxZeile4    = $F318;
  MtxZeile5    = $F319;
  MtxZeile6    = $F31a;
  MtxZeile7    = $F31b;
  MtxZeile8    = $F31c;

  Wand         = $aa;

  KeinBit      = $00;
  HellBit      = $01;
  DickBit      = $02;
  UnterBit     = $04;
  InversBit    = $08;
  BreitBit     = $10;
  HochBit      = $20;
  ExpoBit      = $40;
  IndexBit     = $80;

type
  Schirm       = (hell,dunkel);
  Spieler      = (Niemand,Frank,Kobold);
  FranksZug    = (FrankLinks,FrankRechts,FrankGerade,FrankFaelltRechts,FrankFaelltLinks);
  Video        = (Nichts,Licht,Dick,Unterstrich,Invers,Breit,Hoch,Expo,Index);
  SteinArt     = (Leer,Wand1,Apfel,Kirsche,Banane,Birne,Kuerbis,Unb1,Unb2,Wand2);
  LangString   = string[255];
  NameString   = string[ 20];
  FR_F0Code    = array[0..457] of byte;
  FR_F3Code    = array[0.. 20] of byte;

var
  FR_F0Prog     : FR_F0Code absolute $F000;
  FR_F3Prog     : FR_F3Code absolute $F300;

  i             : integer;
  j             : integer;
  Stand         : integer;
  Gewinner      : Spieler;
  StandWert     : byte;
  FeldZahl      : byte;
  StandZahl     : byte;
  XKopie        : byte;
  YKopie        : byte;
  XPos          : byte;
  YPos          : byte;
  Einmal        : byte;         {WIRD NUR EINMAL ANGEFASST}
  FranksRichtung: FranksZug;
  LaufZahl      : byte;
  Ebene         : byte;
  Keinmal       : byte;         {UNGENUTZT}
  SpielX        : byte;
  SpielY        : byte;
  FruchtZahl    : byte;
  WandZeichen   : byte;
  Auswahl       : char;
  Wichtung      : array[1..3] of byte;
  Aufstellung   : array[1..2,1..3] of byte;
  Bewegung      : array[1..2,1..3] of integer;
  Spielfeld     : array[0..BordSpalten,0..BordReihen] of SteinArt;
  ArbeitsFeld   : NameString;
  SpielerName   : array[1..StandLaenge] of NameString;
  SpielerStand  : array[1..StandLaenge] of integer;
  StandDatei    : text;

procedure FR_Msg;    external $F000;

procedure FR_Matrix; external $F300;

procedure Zeichen_setzen;
{Routine zum Manipulieren von Zeichen in den Speicher verschieben}
const
  FR_F000:FR_F0Code =
         (
  {0000}  $6e,$1a,$67,$2d,$25,$22,$bd,$f1,$69,$60,$7e,$b7,$c8,$4f,$06,$00,
  {0010}  $32,$bc,$f1,$23,$7e,$23,$66,$6f,$11,$e9,$f1,$ed,$b0,$01,$26,$f0,
  {0020}  $cd,$5a,$fc,$e9,$00,$c9,$3a,$bc,$f1,$47,$21,$e9,$f1,$7e,$fe,$1b,
  {0030}  $20,$0b,$23,$05,$c8,$7e,$32,$bb,$f1,$23,$05,$c8,$7e,$c5,$e5,$6f,
  {0040}  $26,$00,$29,$29,$29,$11,$00,$b8,$19,$11,$c9,$f1,$01,$08,$00,$ed,
  {0050}  $b0,$21,$01,$01,$22,$bf,$f1,$3a,$bb,$f1,$fe,$ff,$28,$29,$1f,$dc,
  {0060}  $bc,$f0,$1f,$dc,$ce,$f0,$1f,$dc,$b6,$f0,$1f,$dc,$de,$f0,$1f,$dc,
  {0070}  $ec,$f0,$1f,$dc,$17,$f1,$1f,$dc,$3d,$f1,$1f,$dc,$3a,$f1,$cd,$66,
  {0080}  $f1,$e1,$c1,$23,$10,$a7,$c9,$21,$c9,$f1,$06,$08,$ed,$5b,$bd,$f1,
  {0090}  $7a,$90,$57,$14,$c5,$d5,$e5,$06,$08,$4e,$cb,$01,$21,$c9,$f1,$38,
  {00a0}  $03,$21,$c1,$f1,$cd,$92,$f1,$1c,$7b,$10,$ef,$e1,$d1,$c1,$23,$10,
  {00b0}  $e2,$32,$bd,$f1,$18,$cb,$21,$d0,$f1,$36,$ff,$c9,$f5,$21,$c9,$f1,
  {00c0}  $06,$08,$7e,$cb,$3f,$a6,$77,$23,$10,$f8,$f1,$cb,$87,$c9,$f5,$21,
  {00d0}  $c9,$f1,$06,$08,$7e,$cb,$3f,$b6,$77,$23,$10,$f8,$f1,$c9,$f5,$21,
  {00e0}  $c9,$f1,$06,$08,$7e,$2f,$77,$23,$10,$fa,$f1,$c9,$f5,$3e,$02,$32,
  {00f0}  $bf,$f1,$dd,$21,$c9,$f1,$0e,$08,$06,$08,$dd,$7e,$00,$1f,$dd,$cb,
  {0100}  $00,$1e,$dd,$cb,$10,$1e,$dd,$cb,$00,$2e,$dd,$cb,$10,$1e,$10,$ed,
  {0110}  $dd,$23,$0d,$20,$e3,$f1,$c9,$3e,$02,$32,$c0,$f1,$11,$d0,$f1,$cd,
  {0120}  $2a,$f1,$3a,$bf,$f1,$3d,$c8,$11,$e0,$f1,$21,$08,$00,$19,$06,$08,
  {0130}  $1a,$1b,$77,$2b,$77,$2b,$10,$f8,$af,$c9,$af,$18,$02,$3e,$02,$32,
  {0140}  $c0,$f1,$11,$d8,$f1,$cd,$50,$f1,$3a,$bf,$f1,$3d,$c8,$11,$e8,$f1,
  {0150}  $cd,$5c,$f1,$21,$fc,$ff,$19,$01,$08,$00,$ed,$b8,$af,$12,$1b,$12,
  {0160}  $1b,$12,$1b,$12,$1b,$c9,$21,$c9,$f1,$ed,$4b,$bf,$f1,$ed,$5b,$bd,
  {0170}  $f1,$d5,$e5,$15,$05,$05,$cc,$92,$f1,$14,$cd,$92,$f1,$14,$04,$04,
  {0180}  $cc,$92,$f1,$e1,$11,$10,$00,$19,$d1,$1c,$0d,$20,$e4,$ed,$53,$bd,
  {0190}  $f1,$c9,$7b,$fe,$5a,$d0,$7a,$fe,$20,$d0,$c5,$d5,$e5,$16,$00,$07,
  {01a0}  $17,$17,$17,$6f,$7a,$ce,$b6,$67,$7e,$23,$66,$6f,$eb,$29,$29,$19,
  {01b0}  $29,$eb,$e1,$01,$08,$00,$ed,$b0,$d1,$c1,$c9,$00,$00,$00,$00,$00,
  {01c0}  $00,$00,$00,$00,$00,$00,$00,$00,$00,$00);

begin {Zeichen_setzen}
  move(FR_F000,FR_F0Prog,458);
end;

function Video_Attribut(mode:Video):byte;
{Video-Attribut berechnen}
begin
  case mode of
    Nichts:      Video_Attribut:=KeinBit;
    Licht:       Video_Attribut:=HellBit;
    Dick:        Video_Attribut:=DickBit;
    Unterstrich: Video_Attribut:=UnterBit;
    Invers:      Video_Attribut:=InversBit;
    Breit:       Video_Attribut:=BreitBit;
    Hoch:        Video_Attribut:=HochBit;
    Expo:        Video_Attribut:=ExpoBit;
    Index:       Video_Attribut:=IndexBit;
  end;
end;

procedure Video_String(x,y,mode:byte;strg:LangString);
{String fuer Zeichenmanipulation zusammenstellen}
var
  xzgr         : integer;
  yzgr         : integer;
  strzgr       : integer;
begin
  xzgr:=addr(x);
  yzgr:=addr(y);
  strzgr:=addr(strg);
  strg:=chr(lo(strzgr+3))+chr(hi(strzgr+3))+esc+chr(mode)+strg;
  mem[strzgr]:=mem[strzgr]-2;
  inline ($2a/xzgr/        {  ld hl,(xzgr)  }
          $ed/$5b/yzgr/    {  ld de,(yzgr)  }
          $ed/$4b/strzgr); {  ld bc,(strzgr)}
  FR_Msg;
end;

procedure Setze_Matrix(Zeichen,Zeile1,Zeile2,Zeile3,Zeile4,Zeile5,Zeile6,Zeile7,Zeile8:byte);
{Neue Zeichenmatrix setzen}
begin
  mem[MtxAdr1]:=lo(Zeichen*8+CHARMTX); {Matrixadresse ermitteln}
  mem[MtxAdr2]:=hi(Zeichen*8+CHARMTX);
  mem[MtxZeile1]:=Zeile1;              {Muster in Matrix schreiben}
  mem[MtxZeile2]:=Zeile2;
  mem[MtxZeile3]:=Zeile3;
  mem[MtxZeile4]:=Zeile4;
  mem[MtxZeile5]:=Zeile5;
  mem[MtxZeile6]:=Zeile6;
  mem[MtxZeile7]:=Zeile7;
  mem[MtxZeile8]:=Zeile8;
  FR_Matrix;                           {Neues Muster in Matrix schreiben}
end;

procedure Schirm_blinken(SchirmArt:Schirm);
{Bildschirm blinken lassen}
begin
  if (SchirmArt=dunkel) then write(SchirmDunkel);
  if (SchirmArt=hell)   then write(SchirmHell);
end;

procedure Cursor_Aus;
{Cursor ausschalten}
begin
  write(CursorAus);
end;

procedure Cursor_An;
{Cursor einschalten}
begin
  write(CursorAn);
end;

procedure Klingel;
{Klingeln mittels JOYCE-Kontrollport}
begin
  port[$f8]:=11; {Klingel an}
  delay(5);
  port[$f8]:=12; {Klingel aus}
end;

procedure History_Datei_erstellen;
{History-Datei schreiben}
begin
  assign(StandDatei,StandName);
  rewrite(StandDatei);
  for i:=1 to StandLaenge do
  begin
    writeln(StandDatei,SpielerName[i]);
    writeln(StandDatei,SpielerStand[i]:5);
  end;
  close(StandDatei);
  write(StatusAn);     {Statuszeile einschalten}
  Cursor_An;           {Cursor einschalten}
  clrscr;
  halt;
end;

procedure Fruit_Init;
{History-Datei einlesen und Zeichen fuer das Spiel definieren}
const
  FR_F300:FR_F3Code =
         (
  {0000}  $01,$09,$f3,$cd,$5a,$fc,$e9,$00,$c9,$21,$15,$f3,$01,$08,$00,$11,
  {0010}  $00,$b8,$ed,$b0,$c9);

begin {Fruit_Init}
  assign(StandDatei,StandName);
  reset(StandDatei);
  if (ioresult<>0) then
    for i:=1 to StandLaenge do
    begin
      SpielerName[i]:=LeerName;
      SpielerStand[i]:=0;
    end
  else
  for i:=1 to StandLaenge do
  begin
    readln(StandDatei,SpielerName[i]);
    readln(StandDatei,SpielerStand[i]);
  end;
  close(StandDatei);

  move(FR_F300,FR_F3Prog,21);
  Setze_Matrix($a0,$1c,$3e,$2e,$6e,$3e,$1c,$0c,$1e);
  Setze_Matrix($a1,$3f,$dd,$1c,$1c,$1f,$31,$21,$c0);
  Setze_Matrix($a2,$3f,$dd,$1c,$1c,$14,$12,$14,$30);
  Setze_Matrix($a3,$38,$7c,$74,$76,$7c,$38,$08,$78);
  Setze_Matrix($a4,$fc,$bb,$38,$38,$f8,$8c,$84,$03);
  Setze_Matrix($a5,$fc,$bb,$38,$38,$28,$48,$28,$0e);
  Setze_Matrix($a6,$00,$1c,$3e,$3e,$3e,$1c,$19,$19);
  Setze_Matrix($a7,$7e,$98,$98,$18,$24,$27,$20,$c0);
  Setze_Matrix($a8,$00,$38,$7c,$7c,$7c,$38,$98,$98);
  Setze_Matrix($a9,$7e,$19,$19,$18,$24,$e4,$04,$03);
  Setze_Matrix($aa,$f2,$9f,$fb,$df,$fe,$f3,$9e,$f3);
  Setze_Matrix($ab,$e6,$bf,$f3,$df,$fc,$ef,$df,$fe);
  Setze_Matrix($ac,$f6,$bf,$fb,$df,$fe,$f7,$be,$ef);
  Setze_Matrix($ad,$ed,$bf,$f7,$bd,$ef,$fb,$df,$fd);
  Setze_Matrix($ae,$e7,$00,$ff,$ff,$ff,$00,$e7,$e7);
  Setze_Matrix($af,$ff,$00,$e7,$e7,$e7,$00,$ff,$ff);
  Setze_Matrix($b0,$00,$03,$0c,$12,$20,$10,$18,$20);
  Setze_Matrix($b1,$00,$c0,$20,$30,$4a,$04,$04,$18);
  Setze_Matrix($b2,$40,$28,$10,$24,$4c,$36,$21,$00);
  Setze_Matrix($b3,$04,$02,$42,$22,$34,$4c,$80,$00);
  Setze_Matrix($b4,$00,$01,$00,$1c,$3e,$6f,$7d,$6f);
  Setze_Matrix($b5,$00,$00,$80,$b8,$fc,$ce,$e6,$e6);
  Setze_Matrix($b6,$77,$3f,$3b,$1d,$0e,$00,$00,$e7);
  Setze_Matrix($b7,$e6,$fc,$fc,$f8,$70,$00,$00,$ff);
  Setze_Matrix($b8,$00,$00,$0d,$1a,$1f,$0d,$05,$0b);
  Setze_Matrix($b9,$30,$c8,$60,$d0,$f0,$60,$80,$60);
  Setze_Matrix($ba,$07,$0d,$1a,$1e,$0c,$00,$00,$e7);
  Setze_Matrix($bb,$78,$9d,$1e,$0c,$00,$00,$00,$ff);
  Setze_Matrix($bc,$00,$06,$0e,$1c,$1c,$1e,$1e,$0f);
  Setze_Matrix($bd,$00,$00,$00,$00,$00,$00,$00,$00);
  Setze_Matrix($be,$0f,$07,$03,$01,$00,$00,$00,$e7);
  Setze_Matrix($bf,$00,$80,$c0,$e0,$70,$00,$00,$ff);
  Setze_Matrix($c0,$00,$00,$01,$03,$03,$07,$07,$0f);
  Setze_Matrix($c1,$40,$80,$c0,$c0,$c0,$e0,$e0,$f0);
  Setze_Matrix($c2,$09,$11,$33,$3f,$3f,$1e,$00,$e7);
  Setze_Matrix($c3,$f0,$b8,$fc,$ec,$fc,$78,$00,$ff);
  Setze_Matrix($c4,$00,$00,$01,$07,$0f,$1c,$19,$3b);
  Setze_Matrix($c5,$60,$c0,$c0,$e0,$f0,$b8,$98,$dc);
  Setze_Matrix($c6,$bf,$ff,$79,$3c,$1f,$0f,$d7,$70);
  Setze_Matrix($c7,$fc,$fe,$9f,$3d,$f8,$f0,$db,$0e);
  Setze_Matrix($c8,$06,$03,$03,$07,$0f,$1c,$19,$3b);
  Setze_Matrix($c9,$00,$00,$c0,$e0,$f0,$b8,$98,$dc);
  Setze_Matrix($ca,$3f,$7f,$f9,$bc,$1f,$0f,$d7,$70);
  Setze_Matrix($cb,$fd,$ff,$9e,$3c,$f8,$f0,$db,$0e);
  Setze_Matrix($cc,$00,$0f,$38,$77,$6b,$69,$6f,$6f);
  Setze_Matrix($cd,$00,$f0,$1c,$ee,$d6,$96,$f6,$f6);
  Setze_Matrix($ce,$19,$1c,$0e,$07,$07,$0c,$08,$18);
  Setze_Matrix($cf,$98,$38,$70,$e0,$e0,$30,$10,$18);
  Setze_Matrix($d0,$00,$00,$00,$01,$07,$7f,$ff,$0e);
  Setze_Matrix($d1,$00,$70,$d8,$ec,$36,$76,$f6,$76);
  Setze_Matrix($d2,$00,$07,$03,$01,$03,$06,$04,$0c);
  Setze_Matrix($d3,$f8,$f0,$e0,$e0,$60,$30,$10,$10);
  Setze_Matrix($d4,$00,$0e,$1b,$37,$6c,$6e,$6f,$6e);
  Setze_Matrix($d5,$00,$00,$00,$80,$e0,$fe,$ff,$70);
  Setze_Matrix($d6,$1f,$0f,$07,$07,$06,$0c,$08,$08);
  Setze_Matrix($d7,$00,$e0,$c0,$80,$c0,$60,$20,$30);
  Setze_Matrix($d8,$1f,$0f,$07,$06,$04,$08,$08,$0c);
  Setze_Matrix($d9,$00,$e0,$c0,$80,$80,$c0,$60,$30);
  Setze_Matrix($da,$00,$07,$03,$01,$01,$03,$06,$0c);
  Setze_Matrix($db,$f8,$f0,$e0,$60,$20,$10,$10,$30);
  Setze_Matrix($dc,$00,$00,$00,$00,$00,$00,$07,$00);
  Setze_Matrix($dd,$00,$1c,$3e,$2e,$6e,$3c,$18,$fc);
  Setze_Matrix($de,$00,$78,$07,$03,$19,$07,$00,$00);
  Setze_Matrix($df,$7a,$e2,$c4,$80,$80,$c0,$00,$00);
  Setze_Matrix($e0,$00,$38,$7c,$74,$76,$3c,$18,$3f);
  Setze_Matrix($e1,$00,$00,$00,$00,$00,$00,$e0,$00);
  Setze_Matrix($e2,$5e,$47,$23,$01,$01,$03,$00,$00);
  Setze_Matrix($e3,$00,$1e,$e0,$c0,$98,$e0,$00,$00);
  Zeichen_setzen;
  write(StatusAus);     {Turn off status line}
  Cursor_Aus;           {Turn off cursor}
end;

procedure SetzeFrank;
{Grafik fuer Frank positionieren}
var
  xFrank       : byte;
  yFrank       : byte;
begin
  xFrank:=XPos*4+2;
  yFrank:=succ(YPos)+succ(YPos);
  Video_String(pred(xFrank),pred(yFrank),BreitBit,'  ');
  Video_String(pred(xFrank),yFrank,      BreitBit,'  ');
  case FranksRichtung of
    FrankLinks:
        begin
                            Video_String(xFrank,pred(yFrank),BreitBit,#$a0);{Gehe links}
          if odd(XPos) then Video_String(xFrank,yFrank,BreitBit,#$a1)       {..weit}
                       else Video_String(xFrank,yFrank,BreitBit,#$a2);      {..eng}
        end;
    FrankRechts:
        begin
                            Video_String(xFrank,pred(yFrank),BreitBit,#$a3);{Gehe rechts}
          if odd(XPos) then Video_String(xFrank,yFrank,BreitBit,#$a4)       {..weit}
                       else Video_String(xFrank,yFrank,BreitBit,#$a5);      {..eng}
        end;
    FrankGerade:
        if odd(YPos) then
        begin
          Video_String(xFrank,pred(yFrank),BreitBit,#$a6);                  {Gehe geradeaus}
          Video_String(xFrank,yFrank,      BreitBit,#$a7);                  {..links}
        end else
        begin
          Video_String(xFrank,pred(yFrank),BreitBit,#$a8);                  {Gehe geradeaus}
          Video_String(xFrank,yFrank,      BreitBit,#$a9);                  {..rechts}
        end;
    FrankFaelltRechts:
        begin
          Video_String(pred(xFrank),pred(yFrank),BreitBit,#$dc#$dd);        {Falle nach rechts}
          Video_String(pred(xFrank),yFrank,      BreitBit,#$de#$df);
        end;
    FrankFaelltLinks:
        begin
          Video_String(pred(xFrank),pred(yFrank),BreitBit,#$e0#$e1);        {Falle nach links}
          Video_String(pred(xFrank),yFrank,      BreitBit,#$e2#$e3);
        end;
  end;
end;

procedure SetzeFrucht(FrX,FrY:byte);
{Grafik fuer Frucht positionieren}
var
  xFruit       : byte;
  yFruit       : byte;
begin
  xFruit:=succ(FrX*4);
  yFruit:=FrY+FrY+2;
  case Spielfeld[FrX,FrY] of
      Leer    : Video_String(xFruit,yFruit,BreitBit+HochBit,'  ');     {Feld loeschen}
   Wand1,Wand2: Video_String(xFruit,yFruit,BreitBit+HochBit,char(WandZeichen)+char(succ(WandZeichen)));
                                                                       {Wand-Typ}
      Apfel   : begin
                  Video_String(xFruit,pred(yFruit),BreitBit,#$b4#$b5); {Apfel}
                  Video_String(xFruit,yFruit,      BreitBit,#$b6#$b7);
                end;
     Kirsche  : begin
                  Video_String(xFruit,pred(yFruit),BreitBit,#$b8#$b9); {Kirsche}
                  Video_String(xFruit,yFruit,      BreitBit,#$ba#$bb);
                end;
     Banane :   begin
                  Video_String(xFruit,pred(yFruit),BreitBit,#$bc#$bd); {Banane}
                  Video_String(xFruit,yFruit,      BreitBit,#$be#$bf);
                end;
      Birne : begin
                  Video_String(xFruit,pred(yFruit),BreitBit,#$c0#$c1); {Birne}
                  Video_String(xFruit,yFruit,      BreitBit,#$c2#$c3);
                end;
  end;
  if ((FrX=SpielX) and (FrY=SpielY)) then
  begin
    Video_String(xFruit,pred(yFruit),BreitBit,#$b0#$b1);               {Knall???}
    Video_String(xFruit,yFruit,      BreitBit,#$b2#$b3);
  end;
end;

procedure SetzeKuerbis(KuerbX,KuerbY:byte);
{Grafik fuer Kuerbis positionieren}
var
  xKuerbis     : byte;
  yKuerbis     : byte;
begin
  xKuerbis:=succ(KuerbX*4);
  yKuerbis:=KuerbY+KuerbY+2;
  if odd(KuerbY) then
  begin
    Video_String(xKuerbis,pred(yKuerbis),BreitBit,#$c4#$c5); {Springender Kuerbis, links???}
    Video_String(xKuerbis,yKuerbis,      BreitBit,#$c6#$c7);
  end else
  begin
    Video_String(xKuerbis,pred(yKuerbis),BreitBit,#$c8#$c9); {Springender Kuerbis, rechts???}
    Video_String(xKuerbis,yKuerbis,      BreitBit,#$ca#$cb);
  end;
end;

procedure SetzeKobold(KobX,KobY:byte;KoboldRichtung:integer);
{Grafik fuer Kobold positionieren}
var
  xKobold      : byte;
  yKobold      : byte;
begin
  xKobold:=succ(KobX*4);
  yKobold:=KobY+KobY+2;
  case KoboldRichtung of
    0 : begin
          Video_String(xKobold,pred(yKobold),BreitBit,#$cc#$cd);                  {Kobold von vorn}
          Video_String(xKobold,yKobold,      BreitBit,#$ce#$cf);
        end;
    -1: begin
                            Video_String(xKobold,pred(yKobold),BreitBit,#$d0#$d1);{Kobold geht nach links}
          if odd(KobX) then Video_String(xKobold,yKobold,      BreitBit,#$d2#$d3) {..weit}
                       else Video_String(xKobold,yKobold,      BreitBit,#$da#$db);{..eng}
        end;
    1 : begin
                            Video_String(xKobold,pred(yKobold),BreitBit,#$d4#$d5);{Kobold geht nach rechts}
          if odd(KobX) then Video_String(xKobold,yKobold,      BreitBit,#$d6#$d7) {..weit}
                       else Video_String(xKobold,yKobold,      BreitBit,#$d8#$d9);{..eng}
        end;
  end;
end;

