
(* ----- Datei FORMAT3.PAS ------------------------------------------------ *)

(*
 * Entgegen der Dokumentation scheint sich DD_DRIVE_STATUS nicht darum zu
 * kuemmern welches Laufwerk gemeint ist, so dass die Angabe von 'Lw'
 * irrelevant ist.
 * HILFE: Wo liegt da der Fehler? DISCKIT kann's doch auch.
 *)
FUNCTION LaufwerkFrei(Lw:Char):Boolean;
VAR Status : DrStTyp;
BEGIN
   IF Lw='A'
   THEN Status := [LwA]
   ELSE Status := [LwB];
   INLINE($3A/Status/     (* LD   A,(Status)            *)
          $4F/            (* LD   C,A                   *)
          $CD/$5A/$FC/    (* CALL XBIOS                 *)
          $98/$00/        (* DW   0098h DD_DRIVE_STATUS *)
          $32/Status);    (* LD   (Status),A            *)
  LaufwerkFrei := NOT(Ready IN Status);
END;

(*
 * Der Zugriff auf die XDPB's im BIOS wird nicht mehr genutzt, da ich jetzt
 * einen eigenen XDPB im Common-Bereich eingerichtet habe. Da die Routinen
 * aber eventuell fuer andere Programme von Interesse sind habe ich sie
 * hier stehengelassen.
 *)
PROCEDURE InitXDPB;                     (* Zeiger auf XDPB's initialisieren *)
VAR CurDisk : Byte;
BEGIN
  CurDisk:=Bdos(25);
  Bdos(14,0);                       (* Laufwerk A waehlen *)
  XDPB_A := Ptr(BdosHL(31));          (* Adresse des XDPB *)
  Bdos(14,1);                       (* Laufwerk B waehlen *)
  XDPB_B := Ptr(BdosHL(31));          (* Adresse des XDPB *)
  Bdos(14,CurDisk);  (* wieder aktuelles Laufwerk waehlen *)
END;

PROCEDURE MakeDataXDPB; (* XDPB bei $FF4A fuer LW-A initialisieren XBIOS #7 *)
BEGIN
  INLINE($3E/$02/          (* LD   A,2    ;DATA ONLY     *)
         $DD/$21/$4A/$FF/  (* LD   IX,F000h              *)
         $CD/$5A/$FC/      (* CALL FC5Ah  ;XBIOS         *)
         $95/$00)          (* DW   0095h  ;DD_SEL_FORMAT *)
END;

PROCEDURE MakeSystemXDPB;
BEGIN
  INLINE($3E/$01/          (* LD   A,1    ;SYSTEM        *)
         $DD/$21/$4A/$FF/  (* LD   IX,F000h              *)
         $CD/$5A/$FC/      (* CALL FC5Ah  ;XBIOS         *)
         $95/$00)          (* DW   0095h  ;DD_SEL_FORMAT *)
END;

PROCEDURE MakeJoyceXDPB;
BEGIN
  INLINE($3E/$00/          (* LD   A,0    ;JOYCE         *)
         $DD/$21/$4A/$FF/  (* LD   IX,FF4Ah              *)
         $CD/$5A/$FC/      (* CALL FC5Ah  ;XBIOS         *)
         $95/$00)          (* DW   0095h  ;DD_SEL_FORMAT *)
END;

PROCEDURE MakeXDPB_B;   (* XDPB bei $FF65 fuer LW-B initialisieren XBIOS #7 *)
BEGIN
  INLINE($3E/$03/          (* LD   A,3    ;CF2DD         *)
         $DD/$21/$65/$FF/  (* LD   IX,FF65h              *)
         $CD/$5A/$FC/      (* CALL FC5Ah  ;XBIOS         *)
         $95/$00)          (* DW   0095h  ;DD_SEL_FORMAT *)
END;

(*$A-*) (* --------------------------------------------- Rekursion erlauben *)

VAR
  PruefFlag : Boolean;

(*
 * LiesSektor wird zum Pruefen der Diskette benoetigt.
 *)
PROCEDURE LiesSektor(Laufwerk,Spur,Sektor : Byte;
                    XdpbAdresse          : XDPBptr;
                    PufferAdresse        : Integer);
VAR Fehler : Byte;
BEGIN
    INLINE($06/$01/             (* LD   B,1              *)
           $3A/Laufwerk/        (* LD   A,(Laufwerk)     *)
           $4F/                 (* LD   C,A              *)
           $3A/Spur/            (* LD   A,(Spur)         *)
           $57/                 (* LD   D,A              *)
           $3A/Sektor/          (* LD   A,(Sektor)       *)
           $5F/                 (* LD   E,A              *)
           $2A/PufferAdresse/   (* LD   HL,(PufferAdr.)  *)
           $DD/$2A/XdpbAdresse/ (* LD   IX,(XdpbAdresse) *)
           $CD/$5A/$FC/         (* CALL XBIOS            *)
           $86/$00/             (* DW   0086             *)
           $D8/                 (* RET  C                *)
           $32/Fehler);         (* LD   (Fehler),A       *)
  PruefFlag := FALSE;
(*
    CASE FehlerMeldung(Fehler,'Sektorlesen') OF
     'W' : LiesSektor(Laufwerk,Spur,Sektor,XdpbAdresse,PufferAdresse);
     'I' : ;
     'A' : Programmabbruch
    END;
*)
END;

(*
 * Einzelnen Sektor auf der Diskette durch einen Leseversuch pruefen
 *)
FUNCTION SektorOk(Laufwerk,Spur,Sektor : Byte;
                  XdpbAdresse          : XDPBptr;
                  PufferAdresse        : Integer) : BOOLEAN;
BEGIN
  PruefFlag := TRUE;
  LiesSektor(Laufwerk,Spur,Sektor,XdpbAdresse,PufferAdresse);
  SektorOk := PruefFlag;
END;

(*
 * SchreibeSektor wird zum Schreiben des Bootsektors benoetigt.
 *)
PROCEDURE SchreibeSektor(Laufwerk,Spur,Sektor : Byte;
                         XdpbAdresse          : XDPBptr;
                         PufferAdresse        : Integer);
VAR Fehler : Byte;
BEGIN
  INLINE($06/$01/               (* LD   B,1              *)
         $3A/Laufwerk/          (* LD   A,(Laufwerk)     *)
         $4F/                   (* LD   C,A              *)
         $3A/Spur/              (* LD   A,(Spur)         *)
         $57/                   (* LD   D,A              *)
         $3A/Sektor/            (* LD   A,(Sektor)       *)
         $5F/                   (* LD   E,A              *)
         $2A/PufferAdresse/     (* LD   HL,(PufferAdr.)  *)
         $DD/$2A/XdpbAdresse/   (* LD   IX,(XdpbAdresse) *)
         $CD/$5A/$FC/           (* CALL XBIOS            *)
         $89/$00/               (* DW   0089             *)
         $D8/                   (* RET  C                *)
         $32/Fehler);           (* LD   (Fehler),A       *)
  CASE FehlerMeldung(Fehler,'Sektorschreiben') OF
    'W' : SchreibeSektor(Laufwerk,Spur,Sektor,XdpbAdresse,PufferAdresse);
    'I' : ;
    'A' : Programmabbruch
  END;
END;

(*
 * FormatiereSpur formatiert eine Spur mit den Formatinformationen aus dem
 * XDPB und der Spurtabelle. XDPB und Tabelle muessen im Common liegen.
 * Die Tabelle 'MyTable' sollte besser auch als Parameter uebergeben werden.
 *)
PROCEDURE FormatiereSpur(Laufwerk,Spur : Byte;
                         XdpbAdresse   : XDPBptr);
VAR Fehler : Byte;
BEGIN
  INLINE($06/$01/              (* LD   B,01     ;CP/M-Bank    *)
         $3A/Laufwerk/         (* LD   A,Laufwerk             *)
         $4F/                  (* LD   C,A                    *)
         $3A/Spur/             (* LD   A,(Spur) ;Track        *)
         $57/                  (* LD   D,A      ;Track-Nr.    *)
         $1E/$E5/              (* LD   E,0E5h   ;Fuellbyte E5 *)
         $21/MyTable/          (* LD   HL,Table ;Tabellenadr. *)
         $DD/$2A/XdpbAdresse/  (* LD   IX,(XdpbAdresse)       *)
         $CD/$5A/$FC/          (* CALL FC5Ah    ;XBIOS        *)
         $8F/$00/              (* DW   008Fh    ;DD_FORMAT    *)
         $D8/                  (* RET  C                      *)
         $32/Fehler);          (* LD   (Fehler),A             *)
  CASE FehlerMeldung(Fehler,'Spur formatieren') OF
    'W' : FormatiereSpur(Laufwerk,Spur,XdpbAdresse);
    'I' : ;
    'A' : Programmabbruch;
  END;
END;

(*$A+*) (* --------------------------------- Ende der rekursiven Prozeduren *)

(* --------------------------------------------- Ende von FORMAT3.PAS ----- *)
