
(* ----- Datei FORMAT2.PAS ------------------------------------------------ *)

FUNCTION DupChar(Ch:Char; Count:Byte) : Str80;
VAR
  Nr : Byte;
  St : Str80;
BEGIN
  St := '';
  FOR Nr := 1 TO Count DO St := St+Ch;
  DupChar := St;
END;

FUNCTION Right(St:Str80; Breite:Byte) : Str80;
BEGIN
  WHILE Length(St)<Breite DO St := ' '+St;
  Right := St;
END;

FUNCTION Center(St:Str80; Breite:Byte):Str80;
BEGIN
  Center := Right(St,(Breite+Length(St)) DIV 2);
END;

PROCEDURE Hallo;
BEGIN
  WriteLn;
  WriteLn(' ',Titel,DupChar(' ',Breite-Length(Titel)-Length(CopyRt)-2)
                                                                 ,CopyRt,' ');
  WriteLn(DupChar('-',Breite));
  WriteLn(Right('basierend auf XFORMAT von M. Anton ',Breite));
  WriteLn;
END;

PROCEDURE ProgrammAbbruch;
BEGIN
  WriteLn;
  WriteLn(Center('<<< P R O G R A M M   abgebrochen ! >>>',Breite));
  Halt;
END;

FUNCTION Antwort(Msg:Str80; Valid:SetOfChar) : Char;
VAR Ch : Char;
BEGIN
  WHILE KeyPressed DO Read(Kbd,Ch); (* Tastaturpuffer leeren *)
  Write(Center(Msg+' ',Breite),^H);
  REPEAT
    Read(Kbd,Ch);
    Ch := UpCase(Ch);
    IF Ch=^C THEN ProgrammAbbruch; (* Abbruch mit ^C ermoeglichen *)
  UNTIL Ch IN Valid;
  WriteLn(Ch);
  Antwort := Ch;
END;

FUNCTION Weiter : Boolean;
BEGIN
  Weiter := Antwort('Weiter ? ',['J','N'])='J';
  Write(^M);
  ClrEol;
END;

FUNCTION FehlerMeldung(Fehler:Byte; Meldung:Str80) : Char;
BEGIN
  WriteLn(^G);
  IF Fehler <= 8
  THEN WriteLn(Center(FehlerText[Fehler]+' beim '+Meldung,Breite))
  ELSE WriteLn(Center('Unbekannter Fehler Nr.'+ItoA(Fehler)+' beim '+Meldung
                                                                    ,Breite));
  FehlerMeldung := Antwort('W)iederholen, I)gnorieren oder A)bbrechen ? '
                           ,['W','I','A']);
END;

PROCEDURE Warnung(Meldung:Str80);
VAR Weiter : Char;
BEGIN
  WriteLn(^G);
  Weiter := Antwort(Meldung+'! Trotzdem weiter (J/N) : ',['J','N']);
  IF Weiter<>'J' THEN Programmabbruch;
END;

(* --------------------------------------------- Ende von FORMAT2.PAS ----- *)
