
(* ----- Datei FORMAT1.PAS ------------------------------------------------ *)
(*
 * Die Variablen 'MyTable' und 'MyXDPB' muessen im Commonbereich liegen,
 * da sie vom XBIOS angesprochen werden. Der Commonbereich beginnt auf dem
 * JOYCE bei $C000. Die Compilerendadresse muss kleiner sein als der fuer
 * die Adresse von 'MyTable' und 'MyXDPB' angegebene Wert.
 *
 * Folgende Formate werden zur Zeit unterstuetzt:
 * Nr. Size  Lw. Typ   Trk Sek
 *  1   169  A:  CPC   40   9  CPC system
 *  2   173  A:  CF2   40   9  CF2
 *  3   178  A:  CPC   40   9  CPC data only
 *  4   187  A:  CF2   43   9  (x)
 *  5   193  A:  CF2   40  10  (x)
 *  6   208  A:  CF2   43  10  (x)
 *  7   706  B:  CF2DD 80   9  CF2DD
 *  8   740  B:  CF2DD 83   9  (x)
 *  9   784  B:  CF2DD 80  10  (x)
 * 10   824  B:  CF2DD 83  10  (x)
 *
 * Die mit (x) gekennzeichneten Formate sind aus dem jeweiligen JOYCE-
 * Standardformat abgeleitet.
 *)

CONST
  Breite   = 70;
  Titel    = 'FORMAT V3.8';
  CopyRt   = '(c)1995 Andre~ Freystatzky';
  TableAdr = $D000;   (* Adresse von 'MyTable'  immer >= $C000              *)
  XDPB_Adr = $D040;   (* Adresse vom 'MyXDPB'   >= TableAdr+SizeOf(TrackID) *)
  FormCnt  = 10;      (* Anzahl der unterstuetzten Formate *)
  fmCPCsys =  1;      (* Die unterstuetzten Formate nach Groesse geordnet *)
  fm40_9   =  2;
  fmCPCdat =  3;
  fm43_9   =  4;
  fm40_10  =  5;
  fm43_10  =  6;
  fm80_9   =  7;
  fm83_9   =  8;
  fm80_10  =  9;
  fm83_10  = 10;

TYPE
  SetOfChar    = SET OF Char;
  Str255       = String[255];
  Str80        = String[ 80];
  Str40        = String[ 40];
  Str25        = String[ 25];
  Str14        = String[ 14];
  HeaderBuffer = ARRAY[1..FormCnt] OF ARRAY[0..9] OF Byte;
  TrackID      = ARRAY[0..39] OF Byte;
  DrStTyp      = SET OF (LwA,LwB,Kopf,Dummy1,Track0,Ready,SchreibGesch
                                                                     ,Dummy2);
  SektorPuffer = ARRAY[0..511] OF Byte;
  XDPB = RECORD
           SPT : Integer;    (* Records pro Spur *)
           BSH,              (* Blockverschiebefaktor *)
           BLM,              (* Blockmaske *)
           EXM : Byte;       (* Extentmaske *)
           DSM,              (* Blockanzahl-1 *)
           DRM : Integer;    (* Directoryeintraege-1*)
           AL0,AL1 : Byte;   (* Allocation 0 & 1 *)
           CKS,              (* Pruefsummenvektor *)
           OFF : Integer;    (* Anzahl reservierte Spuren *)
           PSH,              (* Phys. Record Verschiebe Faktor *)
           PHM,              (* Phys. Record Verschiebe Maske *)
           SIDE,             (* Seitenverteilung *)
           TPSi,             (* Spuren pro Seite *)
           SePT,             (* Sektoren pro Spur *)
           FIRST : Byte;     (* Erste Sektornummer *)
           Size : Integer;   (* Sektorengroesse *)
           GAP_RW,           (* Gaplength Schreib/Lese *)
           GAP_FMT,          (* Gaplength Format *)
           MODE,             (* Modus *)
           Freeze : Byte;    (* Freezeflag *)
         END;
  XDPBptr   = ^XDPB;
  XDPBfile  = FILE OF XDPB;
  XDPBary   = ARRAY[1..FormCnt] OF XDPB;

VAR
  MyTable : TrackId ABSOLUTE TableAdr;
  MyXDPB  : XDPB    ABSOLUTE XDPB_Adr;
  XDPB_A  : XDPBptr; (* Werte werden von InitXDBP ermittelt *)
  XDPB_B  : XDPBptr;
  GapSet  : Boolean; (* True, wenn die Gaplength vom Anwender gesetzt wurde *)
  GapRW   : Byte;
  GapFMT  : Byte;
  Verify  : Boolean; (* True, wenn die Diskette auch geprueft werden soll *)

CONST
 (*
  * Name des zum jeweiligen Format gehoerenden Laufwerks
  *)
  FormatDrive : ARRAY[1..FormCnt] OF Char =
    'AAAAAABBBB';
(*
 * Aufbau der Disketteninfo im Bootsektor der Diskette
 * Byte
 *   0   Diskettentyp   0=CF2  1=CPCsystem  2=CPCdata  3=CF2DD
 *   1   Diskettenart   0=SS   1(129)=DS flip    2=DS up & over
 *   2   Tracks pro Seite
 *   3   Sektoren pro Track
 *   4   log2(Sektorengroesse) - 7
 *   5   Anzahl reservierter Tracks
 *   6   log2(Blockgroesse) - 7
 *   7   Anzahl Directoryblocks
 *   8   Gap length (read/write)
 *   9   Gap length (format)
 *)
  FormatInfo : HeaderBuffer =
    ( (  1,  0, 40,  9,  2,  2,  3,  2, 42, 82) (* A: system *)
     ,(  0,  0, 40,  9,  2,  1,  3,  2, 42, 82) (* A: 40/9   *)
     ,(  2,  0, 40,  9,  2,  0,  3,  2, 42, 82) (* A: data   *)
     ,(  0,  0, 43,  9,  2,  1,  3,  2, 42, 82) (* A: 43/9   *)
     ,(  0,  0, 40, 10,  2,  1,  3,  2, 12, 23) (* A: 40/10  *)
     ,(  0,  0, 43, 10,  2,  1,  3,  2, 12, 23) (* A: 43/10  *)
     ,(  3,129, 80,  9,  2,  1,  4,  4, 42, 82) (* B: 80/9   *)
     ,(  3,129, 83,  9,  2,  1,  5,  2, 42, 82) (* B: 83/9   *)
     ,(  3,129, 80, 10,  2,  1,  5,  2, 12, 23) (* B: 80/10  *)
     ,(  3,129, 83, 10,  2,  1,  5,  2, 12, 23) (* B: 83/10  *)
    );
 (*
  * Zu jedem Format gehoert ein spezifischer XDPB. Die Werte muessten sich aus
  * dem zugehoerigen FormatInfo des Bootsektors berechnen lassen, wer Lust hat
  * kann sich ja mal daran versuchen. Das haette bei Erweiterungen um neue
  * Formate den Vorteil, dass man sich um den XDPB nicht mehr kuemmern muesste.
  *)
  FormatXDPB : XDPBary =
    ( (SPT:36; BSH:3; BLM:7;  EXM:0; DSM:170;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:2; PSH:2;  PHM:3; SIDE:0;   TPSi:40; SePT:9;  FIRST:65;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:36; BSH:3; BLM:7;  EXM:0; DSM:174;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:1; PSH:2;  PHM:3; SIDE:0;   TPSi:40; SePT:9;  FIRST:1;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:36; BSH:3; BLM:7;  EXM:0; DSM:179;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:0; PSH:2;  PHM:3; SIDE:0;   TPSi:40; SePT:9;  FIRST:193;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:36; BSH:3; BLM:7;  EXM:0; DSM:188;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:1; PSH:2;  PHM:3; SIDE:0;   TPSi:43; SePT:9;  FIRST:1;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:40; BSH:3; BLM:7;  EXM:0; DSM:195;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:1; PSH:2;  PHM:3; SIDE:0;   TPSi:40; SePT:10; FIRST:1;
       Size:512; GAP_RW:12; GAP_FMT:23; Mode:96; Freeze:0)
     ,(SPT:40; BSH:3; BLM:7;  EXM:0; DSM:209;  DRM:63;  AL0:192; AL1:0;
       CKS:16; OFF:1; PSH:2;  PHM:3; SIDE:0;   TPSi:43; SePT:10; FIRST:1;
       Size:512; GAP_RW:12; GAP_FMT:23; Mode:96; Freeze:0)
     ,(SPT:36; BSH:4; BLM:15; EXM:0; DSM:356;  DRM:255; AL0:240; AL1:0;
       CKS:64; OFF:1; PSH:2;  PHM:3; SIDE:129; TPSi:80; SePT: 9; FIRST:1;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:36; BSH:5; BLM:31; EXM:3; DSM:184;  DRM:255; AL0:192; AL1:0;
       CKS:64; OFF:1; PSH:2;  PHM:3; SIDE:129; TPSi:83; SePT:9;  FIRST:1;
       Size:512; GAP_RW:42; GAP_FMT:82; Mode:96; Freeze:0)
     ,(SPT:40; BSH:5; BLM:31; EXM:3; DSM:197;  DRM:255; AL0:192; AL1:0;
       CKS:64; OFF:1; PSH:2;  PHM:3; SIDE:129; TPSi:80; SePT:10; FIRST:1;
       Size:512; GAP_RW:12; GAP_FMT:23; Mode:96; Freeze:0)
     ,(SPT:40; BSH:5; BLM:31; EXM:3; DSM:205;  DRM:255; AL0:192; AL1:0;
       CKS:64; OFF:1; PSH:2;  PHM:3; SIDE:129; TPSi:83; SePT:10; FIRST:1;
       Size:512; GAP_RW:12; GAP_FMT:23; Mode:96; Freeze:0)
    );
 (*
  * Die TrackID's enthalten die Informationen die beim Formatieren in den Kopf
  * der Sektoren auf der Diskette geschrieben werden. Der zehnte Eintrag bei
  * den CPC-Formaten wird vom Programm nie benutzt.
  *)
  Data   : TrackId = ($00,$00,$C1,$02,
                      $00,$00,$C6,$02,
                      $00,$00,$C2,$02,
                      $00,$00,$C7,$02,
                      $00,$00,$C3,$02,
                      $00,$00,$C8,$02,
                      $00,$00,$C4,$02,
                      $00,$00,$C9,$02,
                      $00,$00,$C5,$02,
                      $00,$00,$CA,$02);
  System : TrackId = ($00,$00,$41,$02,
                      $00,$00,$46,$02,
                      $00,$00,$42,$02,
                      $00,$00,$47,$02,
                      $00,$00,$43,$02,
                      $00,$00,$48,$02,
                      $00,$00,$44,$02,
                      $00,$00,$49,$02,
                      $00,$00,$45,$02,
                      $00,$00,$4A,$02);
  Joyce  : TrackId = ($00,$00,$01,$02,
                      $00,$00,$06,$02,
                      $00,$00,$02,$02,
                      $00,$00,$07,$02,
                      $00,$00,$03,$02,
                      $00,$00,$08,$02,
                      $00,$00,$04,$02,
                      $00,$00,$09,$02,
                      $00,$00,$05,$02,
                      $00,$00,$0A,$02);
 (*
  * Der Bootsektor fuer Laufwerk A: ist fuer eine 40 Spur 9 Sektor Diskette
  * vorbereitet. Die Aenderungen fuer andere Formate werden von der Prozedur
  * SchreibeBootSektor erledigt.
  *)
  SektorA : SektorPuffer =
    (  0,  0, 43,  9,  2,  1,  3,  2, 42, 82,  0,  0,  0,  0,  0,  4
    , 49,240,255, 62,255, 50,208,248,  1,255, 90, 33,  0,246, 17,  7
    ,  0, 54, 60, 35, 54,  0, 25, 16,248, 33,  0,246, 43, 54,123, 43
    ,114, 16,249,124, 15,211,245,175,211,246,229,221,225, 33,  0,  0
    ,229, 17,  0,208,  6,  4,205,176,240, 16,251,205,121,240,194, 33
    ,241,209,  6, 16,126,183, 40, 29,229,111, 38,  0, 41,205,176,240
    ,205,176,240,205,214,240,225, 35, 16,234, 33,213,240, 52,213,205
    ,121,240,209, 40,221,205, 64,241,199, 33,  0,208,  6, 64,126,230
    ,240, 32, 34,197,229, 17, 13,  0, 25, 17,214,240,  1,255, 12, 27
    , 26, 43,174,161, 40,  9, 26,254, 63, 32,  8,126,161, 18,175, 14
    ,127, 16,236,225,193, 17, 16,  0, 25,200, 25, 16,209,246,255,201
    ,197,229,  1,247,255,175, 60,  9, 56,252, 71,125,198, 10, 79,235
    ,205,241,240,235,225,193, 20, 20, 35,201, 63, 63, 63, 63, 63, 63
    , 63, 63, 69, 77, 83,  0,197,221, 52,  4,221, 52,  6,  1,  8,  0
    ,221,  9,193,201,219,248,230, 64, 32,250,219,248,230, 64, 40,250
    ,201, 30, 10,197, 14, 64,205,136,241, 56, 21,193,205, 79,241,196
    , 79,241,200,197, 62, 39,184, 32,  1, 15, 71, 14,  0,205,136,241
    ,205,221,241,  2,  7,  0,205,165,241,175, 50,208,248,193, 29, 32
    ,210,205, 64,241, 22,  4,  1, 11, 20,205, 74,241,  1, 12, 80,205
    , 74,241, 21, 32,241, 33,245,255,119,203,126, 40,252, 60,211,248
    ,205,228,240, 62,128,211,247,  1, 10,  1,121,211,248, 24,100,197
    ,229,120, 50, 99,241,121, 50,101,241, 62,  6,211,248,205,221,241
    ,  9,102,  0,  0,  0,  0,  2,  9, 42,255, 22,  2,219,  0,135, 48
    ,251,135,242,124,241,237,162, 32,243, 21, 32,240, 62,  5,211,248
    ,205,201,241,230,203,225,193,201, 58,208,248,184,200,120, 50,208
    ,248,205,228,240,121,211,247,120, 50,164,241,205,221,241,  6,  3
    ,175,  3, 15,  0,  0,229,205,191,241, 48,251, 23, 56,248,225, 23
    ,216,  6,  3, 62,179,227,227,227,227, 61, 32,249, 16,245,201,219
    ,248,230, 32,200,205,228,241,  1,  8, 33,209,248,219,  0,135, 48
    ,251, 58,209,248,240,237,162,227,227,227,227, 24,239,229,205,191
    ,241, 56,251,225,227, 70, 35,227, 14,  1,227,219,  0,135, 48,251
    ,250,246,241,126,237,121, 35,227,227,227, 16,238,201,255, 26, 26);
 (*
  * Es ist zwar etwas widersinnig einen voellig leeren Sektor als Konstante zu
  * definieren, aber es erleichtert die gemeinsame Handhabung der Sektoren fuer
  * Laufwerk A: und B:. Vorgegeben sind 80 Spuren zu 9 Sektoren, die Aenderun-
  * gen macht die Prozedur SchreibeBootSektor.
  *)
  SektorB : SektorPuffer =
    (  3,129, 80,  9,  2,  1,  4,  4, 42, 82,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229
    ,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229,229);
 (*
  * Fehlermeldungen fuer den Diskettenzugriff ueber das XBIOS
  *)
  FehlerText : ARRAY[0..8] OF String[27] =
    ('Laufwerk nicht bereit'
    ,'Diskette schreibgesch}tzt'
    ,'Suche erfolglos'
    ,'Datenfehler'
    ,'Keine Daten'
    ,'Fehlende "data adress mark"'
    ,'Unbekannter Fehler Nr. 6'
    ,'Unbekannter Fehler Nr. 7'
    ,'Unpassende Sektornummer');

(* --------------------------------------------- Ende von FORMAT1.PAS ----- *)
