
(* FORMAT Version 3.8 --------------------------------------------------------
 *
 * Datei: FORMAT.PAS
 *
 * Formatieren von Disketten auf dem Schneider PCW xxxx JOYCE
 * im Schneider CF2-, CF2DD-, SYSTEM- und DATA-ONLY-Format
 *
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * !!                                                                        !!
 * !! Wichtig: Endadresse bei der Uebersetzung kleiner als 'TableAdr' setzen !!
 * !!                                                                        !!
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 *
 * - Basierend auf XFORMAT von M. Anton in PCI 7/87 S.112 ff.
 *             und XXFORMAT von A F S C in PCI 6/88 S.90 ff.
 * - Vielen Dank fuer die korrigierenden Hinweise von H. J. Steller.
 * - Dank auch an Helmut Jungkurz und Wolfgang Traeber die meine
 *   Aufmerksamkeit auf Formate mit 10 Sektoren lenkten.
 *
 * Version 3.0
 *  - Anpassung von XFORMAT (1.0) und XXFORMAT (2.0) an eigene Beduerfnisse
 *
 * Version 3.1
 *  - Benutzerinterface veraendert
 *  - CPC-Formate nur noch mit 40 Spuren, da sonst Patch im System noetig
 *
 * Version 3.2
 *  - Korrekturen
 *
 * Version 3.3
 *  - Unterstuetzung von Laufwerk B:
 *  - XDPB_A und XDPB_B sind keine Konstanten mehr
 *
 * Version 3.4
 *  - Korrekturen
 *
 * Version 3.5
 *  - Formate mit 10 Sektoren in A: und B:
 *  - Kommandozeilenparameter
 *  - Wiederholte Formatierung im gleichen Format
 *  - Eigener XDPB, kein Rueckgriff mehr auf die XDPB's im BIOS
 *
 * Version 3.6
 *  - Menue korrigiert
 *
 * Version 3.7
 *  - GAP-Length per Parameter und Menue einstellbar
 *
 * Version 3.8
 *  - Verifizierung der formatierten Diskette, optional abschaltbar
 *  - Einstellung der GAP-Length korrigiert
 *
 *                                              (c)1993 Andress Freystatzky
 *                                                      Pestalozzistrasse 4
 *                                                      38114  Braunschweig
 *
 * ------------------------------------------------------------------------ *)

PROGRAM Format;

(*$C-*)

(* ----- CONST, TYPE und VAR-Deklarationen -------------------------------- *)

(*$I FORMAT1.PAS *)

(* ----- String in Byte umwandeln ----------------------------------------- *)

FUNCTION AtoI(St : Str14) : Integer;
VAR I,N : Integer;
BEGIN
  Val(St,N,I);
  IF (I = 0) AND (N<=255) AND (N>=0)
  THEN AtoI := N
  ELSE AtoI := 0;
END;

(* ----- Integer in String umwandeln ------------------------------------- *)

FUNCTION ItoA(I : Integer) : Str14;
VAR S : String[6];
BEGIN
  Str(I,S);
  ItoA := S;
END;

(* ----- Meldungen an den Benutzer ---------------------------------------- *)

(*$I FORMAT2.PAS *)

(* ------------------------------------------------------------------------ *)

FUNCTION LaufwerksNummer(Laufwerk:Char) : Byte;  (* 0=A, 1=B, ... *)
BEGIN
  LaufwerksNummer := Ord(Laufwerk)-Ord('A');
END;

(* ----- Zugriffe auf das XBIOS ------------------------------------------- *)

(*$I FORMAT3.PAS *)

(* ------------------------------------------------------------------------ *)

(*
 * Spur der Diskette pruefen
 *)
FUNCTION PruefeSpur(Form,Spur:Byte) : BOOLEAN;
VAR
  Sektor : Byte;
  Puffer : SektorPuffer;
BEGIN
  PruefeSpur := FALSE;
  FOR Sektor := 0 TO FormatInfo[Form,3]-1 DO BEGIN
    IF NOT SektorOk(LaufwerksNummer(FormatDrive[Form]),Spur,Sektor
               ,Ptr(Addr(MyXDPB)),Addr(Puffer)) THEN BEGIN
      WriteLn(' Sektor ',Sektor,' fehlerhaft');
      WriteLn;
      IF Antwort('Formatieren abbrechen (J/N) ? ',['J','N'])='J' THEN BEGIN
        WriteLn;
        WriteLn(Center('Die Diskette ist nicht vollst{ndig formatiert!!!'
                                                                    ,Breite));
        WriteLn;
        Exit;
      END;
      WriteLn;
    END;
  END;
  PruefeSpur := TRUE;
END;

(* ------------------------------------------------------------------------ *)
(*
 * Werte in der Spurtabelle um eine Spur weiterrechnen. Auf Laufwerk B: den
 * Seitenwechsel beruecksichtigen.
 *)
PROCEDURE NextTrack(Laufwerk:Char);
VAR Sek, Off : Byte;
BEGIN
  IF Laufwerk='A' THEN BEGIN
    FOR Sek := 0 TO 9 DO BEGIN
      Off := 4*Sek;
      MyTable[Off] := MyTable[Off]+1;
    END;
  END ELSE BEGIN
    IF MyTable[1]=0 THEN BEGIN                 (* Wenn Seite = 0 *)
      FOR Sek := 0 TO 9 DO BEGIN
        Off := 4*Sek;
        MyTable[Off+1] := 1;       (* Dann gleiche Spur, Seite=1 *)
      END;
    END ELSE BEGIN
      FOR Sek := 0 TO 9 DO BEGIN
        Off := 4*Sek;
        MyTable[Off] := MyTable[Off]+1;   (* Sonst naechste Spur *)
        MyTable[Off+1] := 0;              (*             Seite=0 *)
      END;
    END;
  END;
END;

(* ------------------------------------------------------------------------ *)
(*
 * Diskette ab bestimmter Spur im gegebenen Format formatieren.
 *)
FUNCTION FormatiereAbSpur(Spur:Integer; Form:Byte) : Boolean;
VAR
  Lauf : Integer;
  Ch   : Char;
BEGIN
  FormatiereAbSpur := FALSE;
  IF Verify
  THEN WriteLn(Center('Formatiere und pr}fe Laufwerk '+FormatDrive[Form]+':'
                                                                     ,Breite))
  ELSE WriteLn(Center('Formatiere Laufwerk '+FormatDrive[Form]+':',Breite));
  WriteLn(Center('von Spur '+ItoA(Spur)+' bis Spur '
                                      +ItoA(FormatXDPB[Form].TPSi-1),Breite));
  WriteLn(Center('mit '+ItoA(FormatXDPB[Form].SePT)
                                               +' Sektoren pro Spur',Breite));
  CASE Form OF
    fmCPCsys : WriteLn(Center('im CPC-System Format',Breite));
    fmCPCdat : WriteLn(Center('im CPC-Data-only Format',Breite));
    ELSE       IF Form<fm80_9
               THEN WriteLn(Center('im CF2 Format',Breite))
               ELSE WriteLn(Center('im CF2DD Format',Breite));
  END;
  WriteLn;
  Ch := Antwort('Bitte Diskette in Laufwerk '+FormatDrive[Form]+
                ': einlegen und <RETURN> dr}cken. ',[^M,#27]);
  WriteLn;
  IF Ch=#27 THEN Exit;
  CASE Form OF
    fmCPCsys : MyTable := System;
    fmCPCdat : MyTable := Data;
    ELSE       MyTable := Joyce;
  END;
  MyXDPB := FormatXDPB[Form];   (* Passenden XDPB in den Common-Bereich *)
  IF GapSet THEN BEGIN
    MyXDPB.GAP_RW  := GapRW;
    MyXDPB.GAP_FMT := GapFMT;
  END;
  FOR Lauf:=1 TO Spur DO BEGIN  (* MyTable auf 1. zu formatierende Spur *)
    NextTrack(FormatDrive[Form]);
    IF FormatDrive[Form]='B' THEN NextTrack(FormatDrive[Form]);
  END;
  FOR Lauf:=Spur TO FormatXDPB[Form].TPSi-1 DO BEGIN
    Write(^M,'Formatiere Spur : ',Lauf);
    IF FormatDrive[Form]='A' THEN BEGIN
      FormatiereSpur(LaufwerksNummer(FormatDrive[Form]),
                     Lauf,Ptr(Addr(MyXDPB)));
      IF Verify THEN IF NOT PruefeSpur(Form,Lauf) THEN Exit;
    END ELSE BEGIN
      FormatiereSpur(LaufwerksNummer(FormatDrive[Form]),
                     2*Lauf,Ptr(Addr(MyXDPB)));
      IF Verify THEN IF NOT PruefeSpur(Form,2*Lauf) THEN Exit;
      NextTrack(FormatDrive[Form]);
      FormatiereSpur(LaufwerksNummer(FormatDrive[Form]),
                     2*Lauf+1,Ptr(Addr(MyXDPB)));
      IF Verify THEN IF NOT PruefeSpur(Form,2*Lauf+1) THEN Exit;
    END;
    NextTrack(FormatDrive[Form]);
    IF KeyPressed THEN BEGIN
      WHILE KeyPressed DO Read(KBD,Ch);
      WriteLn;
      WriteLn;
      Ch := Antwort('Wollen sie abbrechen (J/N) ? ',['J','N']);
      IF Ch='J' THEN BEGIN
        WriteLn;
        WriteLn(Center('Die Diskette ist nicht vollst{ndig formatiert!!!'
                                                                    ,Breite));
        WriteLn;
        Exit;
      END;
      WriteLn;
    END;
  END;
  WriteLn;
  WriteLn;
  FormatiereAbSpur := TRUE;
END;

PROCEDURE SchreibeBootSektor(Form:Byte);
VAR Lauf, Sum : Integer;
    Hilf      : Byte;
    Puffer    : SektorPuffer;
BEGIN
  IF (Form<>fmCPCsys) AND (Form<>fmCPCdat) THEN BEGIN
    (* Bootsektor nur in PCW-Formaten *)
    CASE Form OF
      fm40_9, fm43_9,
      fm40_10, fm43_10 :
        Puffer := SektorA; (* CF2           *)
      fm80_9, fm80_10 :
        Puffer := SektorB; (* CF2DD         *)
    END;
    FOR Lauf := 0 TO 9 DO
      Puffer[Lauf] := FormatInfo[Form,Lauf];
    IF GapSet THEN BEGIN
      Puffer[8] := GapRW;
      Puffer[9] := GapFMT;
    END;
    IF (Form=fm40_10) OR (Form=fm43_10) THEN BEGIN
      Puffer[$B3] := $F6;   (* Zehn statt neun Sektoren *)
      Puffer[$BD] := $0B;   (* Elf statt zehn *)
    END;
    IF (FormatDrive[Form]='A') AND (Form<>fmCPCdat) THEN BEGIN
      Sum:=0;
      FOR Lauf:=0 TO 510 DO Sum:=(Sum+Puffer[Lauf]) AND $FF;
      Puffer[511]:=$FF-Lo(Sum);
    END;
    SchreibeSektor(LaufwerksNummer(FormatDrive[Form]),0,0
                   ,Ptr(Addr(MyXDPB)),Addr(Puffer));
    WriteLn(Center('Bootsektor geschrieben.',Breite));
    WriteLn;
  END;
END;

(* ------------------------------------------------------------------------ *)

PROCEDURE Formatiere(Form:Byte);
VAR Ch : Char;
BEGIN
  REPEAT
    IF FormatiereAbSpur(0,Form)
    THEN SchreibeBootSektor(Form);
    Ch := Antwort('Weitere Diskette im gleichen Format (J/N) ? ',['J','N']);
  UNTIL Ch='N';
END;

PROCEDURE FormatiereNach;
CONST Form = fm43_9; (* CF2 43 9 *)
VAR   Ch   : Char;
BEGIN
  REPEAT
    IF FormatiereAbSpur(40,Form)
    THEN SchreibeBootSektor(Form);
    Ch := Antwort('Weitere Diskette nachformatieren (J/N) ? ',['J','N']);
  UNTIL Ch='N';
END;

(* ------------------------------------------------------------------------ *)
(*
 * Der kleine Gag muss sein, aber jedesmal muss ich den Text nicht sehen,
 * deshalb das Random().
 *)
PROCEDURE VierZeiler;
BEGIN
  Randomize;
  IF Random(10)=3 THEN BEGIN (* Nur hin und wieder anzeigen *)
    WriteLn;
    WriteLn(Right('Kommt! Lasset von Tonne zu Tonne uns eilen!',Breite));
    WriteLn(Right('Wir wollen dem M}ll eine Abfuhr erteilen!  ',Breite));
  END;
END;                                              (* Heinz Erhardt *)

PROCEDURE HilfeParameter;
BEGIN
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('Ausf}hrliche Hilfestellung mit FORMAT /H');
  Halt;
END;

PROCEDURE Hilfe;
BEGIN
  WriteLn('----------------------------------------------------------------');
  WriteLn;
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('Der Parameter "format" beschreibt das gew}nschte Disketten-     ');
  WriteLn('format. Es gibt f}r die meisten Formate mehrere Darstellungen:  ');
  WriteLn('Diskettengr|~e, Spur- und Sektorzahl, Laufwerkskennung oder     ');
  WriteLn('Formatname. Benutzen Sie einfach die Darstellung, die Sie sich  ');
  WriteLn('am leichtesten merken k|nnen.   ');
  WriteLn;
  WriteLn(' format                Laufwerk Spuren Sektoren  Format');
  WriteLn(' -------------------   -------- ------ --------  -------------');
  WriteLn(' 169           SYS       A:       40      9      CPC-System   ');
  WriteLn(' 173   40,9    CF2       A:       40      9      JOYCE CF2    ');
  WriteLn(' 178           DATA      A:       40      9      CPC-Data-only');
  WriteLn(' 187   43,9              A:       43      9                   ');
  WriteLn(' 193   40,10             A:       40     10                   ');
  WriteLn(' 208   43,10   A:        A:       43     10                   ');
  WriteLn;
  WriteLn(' 706   80,9    CF2DD     B:       80      9      JOYCE CF2DD  ');
  WriteLn(' 740   83,9              B:       83      9                   ');
  WriteLn(' 784   80,10             B:       80     10                   ');
  WriteLn(' 824   83,10   B:        B:       83     10                   ');
  WriteLn;
  IF NOT Weiter THEN Exit;

  WriteLn('----------------------------------------------------------------');
  WriteLn;
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('Da einige Rechner mit der in FORMAT 3.6 f}r Laufwerk A:         ');
  WriteLn('vorgegebenen GAP-Length Probleme hatten, benutzt das Programm   ');
  WriteLn('jetzt einen anderen Standardwert. Konkret: GAP-RW = 12 und      ');
  WriteLn('GAP-Format = 23.');
  WriteLn;
  WriteLn('Sollte das jetzt wiederum mit anderen Laufwerken Probleme       ');
  WriteLn('verursachen, was ich nicht hoffe, dann kann man die GAP-Length  ');
  WriteLn('auch per Parameter einstellen. Die Werte sollten, zwischen 6 und');
  WriteLn('12 f}r die Read-Write-GAP bei 10-Sektor-Formaten und bis 42 bei ');
  WriteLn('9-Sektor-Formaten liegen. F}r die Format-GAP sollte man jeweils ');
  WriteLn('etwa die doppelten Werte nehmen.');
  WriteLn;
  IF NOT Weiter THEN Exit;

  WriteLn('----------------------------------------------------------------');
  WriteLn;
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('Bis zur Version 3.7 f}hrte FORMAT keine Verifizierung der       ');
  WriteLn('Diskette durch. Es wurde also ganz frech angenommen, da~ die zu ');
  WriteLn('formatierende Diskette in Ordnung ist und das Formatieren       ');
  WriteLn('funktioniert hat.');
  WriteLn;
  WriteLn('Das machte FORMAT zwar relativ schnell und klappt auch in den   ');
  WriteLn('meisten F{llen, aber auf Nummer sicher geht man damit leider    ');
  WriteLn('nicht. Darum pr}ft FORMAT die Diskette jetzt w{hrend des        ');
  WriteLn('Formatiervorganges. Wer seiner Diskette traut und ein wenig Zeit');
  WriteLn('sparen will, der kann die ]berpr}fung durch Angabe von "-V"     ');
  WriteLn('ausschalten.');
  WriteLn;
  IF NOT Weiter THEN Exit;

  WriteLn('----------------------------------------------------------------');
  WriteLn;
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('FORMAT kann, im Unterschied zu DISCKIT auch Disketten f}r den   ');
  WriteLn('kleinen Bruder CPC formatieren. Da ich aber keinen CPC (mehr)   ');
  WriteLn('habe, konnte ich leider nicht testen, ob das, nach mehreren     ');
  WriteLn('Programm{nderungen, immernoch funktioniert.');
  WriteLn;
  WriteLn('F}r eine entsprechende R}ckmeldung w{re ich dankbar.');
  WriteLn;
  IF NOT Weiter THEN Exit;

  WriteLn('----------------------------------------------------------------');
  WriteLn;
  WriteLn('Aufruf : FORMAT format [GAP rw fmt] [-V]');
  WriteLn;
  WriteLn('Den kleinen Spruch zum guten Schlu~ konnte ich mir nicht        ');
  WriteLn('verkneifen, er stammt, wie schon in den Vorversionen,           ');
  WriteLn('von Heinz Erhardt');
  WriteLn;
  IF NOT Weiter THEN Exit;
END;

(* ------------------------------------------------------------------------ *)

PROCEDURE QueryGapLength;
VAR
  St   : Str40;
BEGIN
  GapSet := FALSE;
  WriteLn;
  REPEAT
    Write('L{nge der Schreib/Lese-GAP : ');
    ReadLn(St);
    IF St='' THEN BEGIN
      WriteLn('Benutze die Original GAP-Werte.');
      Exit;
    END;
    GapRW := AtoI(St);
  UNTIL (GapRW<>0);
  WriteLn;
  REPEAT
    Write('L{nge der Format-GAP       : ');
    ReadLn(St);
    IF St='' THEN BEGIN
      WriteLn('Benutze die Original GAP-Werte.');
      Exit;
    END;
    GapFMT := AtoI(St);
  UNTIL (GapFMT<>0);
  GapSet := TRUE;
END;

(* ------------------------------------------------------------------------ *)

PROCEDURE Menu;
VAR Ch : Char;
BEGIN
  GapSet := FALSE;
  Verify := TRUE;
  REPEAT
    WriteLn;
    WriteLn('Formate f}r Laufwerk A:');
    WriteLn(' 0) 169k CPC system');
    WriteLn(' 1) 173k JOYCE CF2');
    WriteLn(' 2) 178k CPC data only');
    WriteLn(' 3) 187k 43 Spuren 9 Sektoren');
    WriteLn(' 4) 193k 40 Spuren 10 Sektoren');
    WriteLn(' 5) 208k 43 Spuren 10 Sektoren');
    WriteLn;
    WriteLn('Formate f}r Laufwerk B:');
    WriteLn(' 6) 706k JOYCE CF2DD');
    WriteLn(' 7) 740k 83 Spuren 9 Sektoren');
    WriteLn(' 8) 784k 80 Spuren 10 Sektoren');
    WriteLn(' 9) 824k 83 Spuren 10 Sektoren');
    WriteLn;
    WriteLn('Sonstiges');
    WriteLn(' N) CF2-Diskette auf 43 Spuren nachformatieren');
    WriteLn(' G) Alternative GAP-Length festlegen');
    Write  (' V) Diskette pr}fen ( momentan ');
    IF Verify THEN WriteLn('ein )') ELSE WriteLn('aus )');
    WriteLn(' E) Ende');
    WriteLn;
    Ch := Antwort(' Ihre Wahl : ',['0'..'9','N','G','V','E']);
    WriteLn;
    CASE Ch OF
      '0'..'9' : Formatiere(Ord(Ch)-Ord('0')+1);
      'G'      : QueryGapLength;
      'N'      : FormatiereNach;
      'V'      : Verify := NOT Verify;
    END;
    BDOS(13);   (* Reset Disk System *)
  UNTIL Ch='E';
END;

(* ------------------------------------------------------------------------ *)

PROCEDURE ParameterAuswertung;
CONST
  Groesse =
    '....169 173 178 187 193 208 706 740 784 824 ';
  Name    =
    '......SYS   40,9  DATA  43,9  40,10 43,10 80,9  83,9  80,10 83,10 ';
VAR
  Ch : Char;
  St : Str80;
  Nr : Byte;
BEGIN
  GapSet := ParamStr(2)='GAP';
  IF GapSet THEN BEGIN
    GapRW  := AtoI(ParamStr(3));
    GapFMT := AtoI(ParamStr(4));
    IF (GapRW=0) OR (GapFMT=0) THEN HilfeParameter;
  END;
  Verify := (ParamStr(2)<>'-V') AND (ParamStr(5)<>'-V');
  St := ParamStr(1);
  IF (St='?') OR (St='/?') OR (St='-?') THEN BEGIN
    HilfeParameter;
  END ELSE IF (St='H') OR (St='/H') OR (St='-H') THEN BEGIN
    Hilfe;
  END ELSE IF (St='/N') THEN BEGIN
    FormatiereNach;
  END ELSE IF (St='A:') THEN BEGIN
    Formatiere(fm43_10);
  END ELSE IF (St='B:') THEN BEGIN
    Formatiere(fm83_10);
  END ELSE IF (St='CF2') THEN BEGIN
    Formatiere(fm40_9);
  END ELSE IF (St='CF2DD') THEN BEGIN
    Formatiere(fm80_9);
  END ELSE BEGIN
    Nr := Pos(St+' ',Groesse) DIV 4;
    IF Nr=0 THEN Nr := Pos(St+' ',Name) DIV 6;
    IF Nr<>0 THEN BEGIN
      Formatiere(Nr);
    END ELSE BEGIN
      HilfeParameter;
    END;
  END;
END;

(* ------------------------------------------------------------------------ *)

BEGIN
  Hallo;
  IF ParamCount=0
  THEN Menu
  ELSE ParameterAuswertung;
  BDOS(13);   (* Reset Disk System *)
  VierZeiler;
  WriteLn;
END.

(* ---------------------------------------- Ende der Datei FORMAT.PAS ----- *)
