{$A-,B-,D-,E-,F-,I-,L-,N-,O-,R-,S-,V-}
{$M 16384,0,600000 }
(*
   Ein Programm zur Umlautwandlung und Sonderzeichentransformation
   in Wordstar- und Pascaltexten.

   (c) Martin Vogel 1988, 1989, 1996, 1999

   Turbo Pascal 5.0, 7.0

   Version 2 - fr Batchbetrieb
   Version 2.1 - HTML-Ausgabe
   Version 2.11 - nur eine neue Adresse
*)

Var
  ein,
  aus:             TEXT;
  s:               string;
  einpuffer,
  auspuffer:       array[1..20480] of Byte;
  Zeichen,
  dummy28:         Char;
  Wandeln_erlaubt: Boolean;
  x,y:             integer;

procedure tpCPMasc;
(*
  '<- Ein Apostroph!

  Diese Prozedur macht Unsinn, wenn in Kommentaren
  einzelne Apostrophe (') verwendet werden. Diese
  dienen als Schalter, um nur die Umlaute in String-
  konstanten tatschlich zu ndern. Geschweifte und
  eckige Klammern im Programmtext mssen unangetastet
  bleiben!
*)
begin
  Wandeln_erlaubt:=false;
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      If Zeichen='''' Then Wandeln_erlaubt:=not Wandeln_erlaubt;
      If wandeln_erlaubt then
        case zeichen of
        '{': Zeichen := '';
        '[': Zeichen := '';
        '|': Zeichen := '';
        '\': Zeichen := '';
        '}': Zeichen := '';
        ']': Zeichen := '';
        '~': Zeichen := '';
        end;
      Write(aus,Zeichen)
    end;
end;

procedure tpASCcpm;
(*
  '<- Ein Apostroph!

  Diese Prozedur macht Unsinn, wenn in Kommentaren
  einzelne Apostrophe (') verwendet werden. Diese
  dienen als Schalter, um nur die Umlaute in String-
  konstanten in ASCII-Klammern zu ndern. Geschweifte
  und eckige Klammern im Programmtext drfen auf
  keinen Fall erzeugt werden. Hier knnte vom Compiler
  eine Bemerkung vorzeitig fr beendet gehalten werden
  und so die Wandlung zu Fehlern fhren. Die Umlaute
  auerhalb von Stringkonstanten werden daher in die
  Zweibuchstaben-Ersatzform gewandelt.
*)
begin
  Wandeln_erlaubt:=false;
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      If Zeichen='''' Then Wandeln_erlaubt:=not Wandeln_erlaubt;
      If wandeln_erlaubt then
        begin
          case zeichen of
          '': Zeichen := '{';
          '': Zeichen := '[';
          '': Zeichen := '|';
          '': Zeichen := '\';
          '': Zeichen := '}';
          '': Zeichen := ']';
          '': Zeichen := '~';
          end;
          write(aus,zeichen);
        end
      ELSE
        begin
          case zeichen of
          '': write(aus,'ae');
          '': write(aus,'Ae');
          '': write(aus,'oe');
          '': write(aus,'Oe');
          '': write(aus,'ue');
          '': write(aus,'Ue');
          '': write(aus,'ss');
          else write(aus,zeichen);
          end;
      end;
    end;
end;

procedure wsIBMasc;
(*
   Drucksteuerzeichen werden entfernt und das achte Bit (auer
   natrlich bei Sonderzeichen!) gelscht. Ein ^O wird zum
   Leerzeichen und ein weicher Trennstrich am Zeilenende
   zu einem richtigen.
*)
begin
  while not eof(Ein) do
  begin
    read(Ein,zeichen);
    Zeichen:=chr(ord(zeichen)and $7f);
    Case Zeichen of
      #15: write(aus,' ');
      #27: begin read(ein,zeichen,dummy28);write(aus,zeichen);end;
      #31: write(aus,'-');
    else If
      (Zeichen>=#32) OR
      (Zeichen=#10) OR
      (Zeichen=#13)
      Then write(aus,Zeichen);
    end
  end;
end;

procedure wsASCibm;
(* Die kleinste in dieser Sammlung *)
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      If Zeichen > #127
        then Write(aus,#27,Zeichen,#28)
      Else
        Write(aus,Zeichen);
    end;
end;

procedure wsIBMcpm;
(*
  Unerkannte Grafikzeichen (In der jetzigen Version alles auer
  Umlauten) werden im Ausgabetext in der Form "<code>" darge-
  stellt. "code" ist der Ordinalwert des Grafikzeichens.
    Die linke obere Rahmenecke "" stnde dann als "<201>" in
  der Datei.
    Das achte Bit bleibt meist erhalten, ebenso wie alle Druck-
  steuerzeichen. Der Einfachheit halber wird das achte Bit bei
  gewandelten Sonderzeichen nicht ersetzt. Hier steht vor dem
  Zeichen in der Eingangsdatei dann ein #155 (27+128=155).
*)
begin
  while not eof(Ein) do
  begin
    read(Ein,zeichen);
    If Zeichen in [#27,#155] then
      BEGIN
        read(ein,zeichen,dummy28);
        case zeichen of
        '': Zeichen := '{';
        '': Zeichen := '[';
        '': Zeichen := '|';
        '': Zeichen := '\';
        '': Zeichen := '}';
        '': Zeichen := ']';
        '': Zeichen := '~';
        end;
        If Zeichen>#127 then write(aus,'<',ord(Zeichen),'>')
        ELSE write(Aus,zeichen);
      END
    ELSE
      write(aus,Zeichen);
  end;
end;

procedure wsCPMibm;
(*
  Hier gibt es nicht viel zu tun. Jedoch gilt auch hier,
  da das achte Bit berall, auer bei gewandelten Zeichen,
  erhalten bleibt.
*)
begin
  while not eof(Ein) do
  begin
    read(Ein,zeichen);
    Case chr(ord(zeichen)and $7f) of
    '{':Write(aus,#27,'',#28);
    '}':Write(aus,#27,'',#28);
    '|':Write(aus,#27,'',#28);
    '[':Write(aus,#27,'',#28);
    ']':Write(aus,#27,'',#28);
    '\':Write(aus,#27,'',#28);
    '~':Write(aus,#27,'',#28);
    else Write(aus,zeichen);
    END;
  end;
end;


procedure txCPMasc;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      case zeichen of
        '{': Zeichen := '';
        '[': Zeichen := '';
        '|': Zeichen := '';
        '\': Zeichen := '';
        '}': Zeichen := '';
        ']': Zeichen := '';
        '~': Zeichen := '';
      end;
      Write(aus,Zeichen)
    end;
end;

procedure txASCcpm;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      case zeichen of
        '': Zeichen := '{';
        '': Zeichen := '[';
        '': Zeichen := '|';
        '': Zeichen := '\';
        '': Zeichen := '}';
        '': Zeichen := ']';
        '': Zeichen := '~';
      end;
      write(aus,zeichen);
    end;
end;

procedure txCPMnix;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      case zeichen of
        '{': write(aus,'ae');
        '[': write(aus,'Ae');
        '|': write(aus,'oe');
        '\': write(aus,'Oe');
        '}': write(aus,'ue');
        ']': write(aus,'Ue');
        '~': write(aus,'ss');
      else write(aus,zeichen);
      end;
    end;
end;

procedure txASCnix;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      if zeichen>#127 then
      case zeichen of
        '': write(aus,'ae');
        '': write(aus,'Ae');
        '': write(aus,'oe');
        '': write(aus,'Oe');
        '': write(aus,'ue');
        '': write(aus,'Ue');
        '': write(aus,'ss');
        '': write(aus,'|');
        '': write(aus,'-');
        '','','','','','','','',
        '': write(aus,'+');
      else write(aus,zeichen)
      end
      else write(aus,zeichen)
    end;
end;

procedure txWINnix;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      case zeichen of
        '': write(aus,'ae');
        '': write(aus,'Ae');
        '': write(aus,'oe');
        '': write(aus,'Oe');
        '': write(aus,'ue');
        '': write(aus,'Ue');
        '': write(aus,'ss');
      else write(aus,zeichen);
      end;
    end;
end;

procedure txDOSwin;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      if zeichen>#127 then
      case zeichen of
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'|');
        '': write(aus,'-');
        '','','','','','','','',
        '': write(aus,'+');
      else write(aus,zeichen);
      end
      else write(aus,zeichen);
    end;
end;

procedure txWINdos;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      case zeichen of
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
        '': write(aus,'');
      else write(aus,zeichen);
      end;
    end;
end;

procedure txUMLhtm;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      if zeichen>#127 then
      case zeichen of
        '','': write(aus,'&auml;');
        '','': write(aus,'&Auml;');
        '','': write(aus,'&ouml;');
        '','': write(aus,'&Ouml;');
        '','': write(aus,'&uuml;');
        '','': write(aus,'&Uuml;');
        '','': write(aus,'&szlig;');
        '': write(aus,'|');
        '': write(aus,'-');
        '','','','','','','','',
        '': write(aus,'+');
      else write(aus,zeichen)
      end
      else write(aus,zeichen)
    end;
end;

procedure txUMLnix;
begin
  While not eof(ein) do
    begin
      Read(ein,Zeichen);
      if zeichen>#127 then
      case zeichen of
        '','': write(aus,'ae');
        '','': write(aus,'Ae');
        '','': write(aus,'oe');
        '','': write(aus,'Oe');
        '','': write(aus,'ue');
        '','': write(aus,'Ue');
        '','': write(aus,'ss');
        '': write(aus,'|');
        '': write(aus,'-');
        '','','','','','','','',
        '': write(aus,'+');
      else write(aus,zeichen)
      end
      else write(aus,zeichen)
    end;
end;

procedure ende;
begin
writeln;
writeln('Guestbookware von: Martin Vogel, Dortmund');
Writeln('                   martin.vogel@ruhr-uni-bochum.de');
Writeln;
Writeln('Wenn Sie dieses Programm regelmaessig anwenden, sollten Sie sich in mein');
Writeln('Gaestebuch eintragen: http://homepage.ruhr-uni-bochum.de/martin.vogel');
end;

procedure fehler;
begin
writeln;
writeln('Fehler beim Oeffnen von "',paramstr(2),'"!');
halt(1);
end;

begin  (************* Hauptprogramm ****************)
  Writeln;
  writeln('BUMWA - Der batchfaehige Umlautwandler');
  writeln('Version 2.11 (c) Martin Vogel, 1999-02-21');
  writeln;
  writeln('Format: BUMWA Kennziffer Dateiname');
  writeln;
  writeln('Die Kennziffern steuern die Art der Konvertierung:');
  writeln('Pascal-Programme:    1: {|}       -> ');
  writeln('                     2:        -> {|}');
  writeln('  Wordstar-Texte:    3: IBM-WS    -> IBM-ASCII (DOS)');
  writeln('                     4: IBM-ASCII -> IBM-WS');
  writeln('                     5: IBM-WS    -> CP/M-WS');
  writeln('                     6: CP/M-WS   -> IBM-WS');
  writeln('  Sonstige Texte:    7: {|}       -> ');
  writeln('                     8:        -> {|}');
  writeln('                     9: {|} (CPM) -> keine');
  writeln('                     A:  +  -> keine');
  writeln('                     B:  (WIN) ->  (DOS)');
  writeln('                     C:  (DOS) ->  (WIN)');
  writeln('                     D:  +  -> &*uml; (HTML)');
  writeln;
  writeln('Die Eingabedatei wird bei der Konvertierung ueberschrieben,');
  writeln('sie darf daher nicht schreibgeschuetzt sein.');
  writeln;

  assign(Ein,paramstr(2));
  settextbuf(ein,einpuffer);
  reset(Ein);
  if ioresult<>0 then fehler;
  assign(aus,'bumwa!__.$$$');
  settextbuf(aus,auspuffer);
  rewrite(aus);
  s:=paramstr(1);
  zeichen:=upcase(s[1]);
  write  ('Konvertierung Typ "',zeichen,'" mit "',paramstr(2),'" laeuft... ');
  case zeichen of
    '1': tpcpmasc;
    '2': tpasccpm;
    '3': wsibmasc;
    '4': wsascibm;
    '5': wsibmcpm;
    '6': wscpmibm;
    '7': txcpmasc;
    '8': txasccpm;
    '9': txcpmnix;
    'A': txumlnix;
    'B': txwindos;
    'C': txdoswin;
    'D': txumlhtm;
  end;
  close(ein);
  close(aus);
  erase(ein);
  rename(aus,paramstr(2));
  writeln('Fertig!');
  ende;
end.
