Overlay procedure gs_musik(stueck:Byte);

type
  TArray25 = array[0..24] of Integer;
  TNoten   = array[0..14] of Integer;
  TStr60   = string[60];

var
  i: Integer;

procedure Pause(Dauer: Integer);
(*************************************************************)
(* Recht brutale Art, etwas Zeit zu verbraten ...            *)
(*************************************************************)
var
  i: Integer;
begin
  for i := 1 to 25*Dauer do;
end;

procedure Sound_org(t,c: Integer);
(*************************************************************)
(* Ausgabe eines Tons mit                                    *)
(*     t = ?Frequenz?                                        *)
(*     c = ?Anzahl Schwingungen?                             *)
(* DIESE VERSION KANN NICHT LAUFEN UND DIENT NUR ALS DEMO!!  *)
(*************************************************************)
begin
  inline(
    $e5/		(* push hl		*)
    $d5/		(* push de		*)
    $c5/		(* push bc		*)
    $dd/$e5/		(* push ix		*)
    $4e/		(* ld c,(hl)		*)
    $23/		(* inc hl		*)
    $46/		(* ld b,(hl)		*)
    $eb/		(* ex de,hl		*)
    $5e/		(* ld e,(hl)		*)
    $23/		(* inc hl		*)
    $56/		(* ld d,(hl)		*)
    $69/		(* ld l,c		*)
    $60/		(* ld h,b		*)
    $cd/$1b/$cb/	(* call sub_cb1b	*)	
    $3e/$0c/		(* ld a,0ch		*)
    $d3/$f8/		(* out(0f8h),a		*)
    $dd/$e1/		(* pop ix		*)
    $c1/		(* pop bc		*)
    $d1/		(* pop de		*)
    $e1/		(* pop hl		*)
    $c9/		(* ret			*)

(* sub_cb1b: *)
    $f3/		(* di			*)
    $7d/		(* ld a,l		*)
    $cb/$3d/		(* srl l		*)
    $cb/$3d/		(* srl l		*)
    $2f/		(* cpl			*)
    $e6/$03/		(* and 03h		*)
    $4f/		(* ld c,a		*)
    $06/$00/		(* ld b,00h		*)
    $dd/$21/$30/$cb/	(* ld ix,lcb30h		*)
    $dd/$09/		(* add ix,bc		*)
    $3e/$0b/		(* ld a, 0bh		*)
    $00/		(* nop			*)

(* lcb30h: *)
    $00/		(* nop			*)
    $00/		(* nop			*)
    $04/		(* inc b		*)
    $0c/		(* inc c		*)

(* lcb34h: *)
    $0d/		(* dec c		*)
    $20/$fd/		(* jr nz,lcb34h		*)
    $0e/$3f/		(* ld c,3fh		*)
    $05/		(* dec b		*)
    $20/$f8/		(* jr nz,lcb34h		*)
    $3c/		(* inc a		*)
    $fe/$0d/		(* cp 0dh		*)
    $20/$02/		(* jr nz,lcb43h		*)
    $3d/		(* dec a		*)
    $3d/		(* dec a		*)

(* lcb43h: *)
    $d3/$f8/		(* out (0f8h),a		*)
    $44/		(* ld b,h		*)
    $4f/		(* ld c,a		*)
    $fe/$0b/		(* cp 0bh		*)
    $20/$09/		(* jr nz,lcb54h		*)
    $7a/		(* ld a,d		*)
    $b3/		(* or e			*)
    $28/$09/		(* jr z,lcb58h		*)
    $79/		(* ld a,c		*)
    $4d/		(* ld c,l		*)
    $1b/		(* dec de		*)
    $dd/$e9/		(* jp (ix)		*)

(* lcb54h: *)
    $4d/		(* ld c,l		*)
    $0c/		(* inc c		*)
    $dd/$e9/		(* jp (ix)		*)

(* lcb58h: *)
    $fb/		(* ei			*)
    $c9			(* ret			*)
  );
end;


procedure Sound(t,c: Integer);
(*************************************************************)
(* Ausgabe eines Tons mit                                    *)
(*     t = ?Frequenz?                                        *)
(*     c = ?Anzahl Schwingungen?                             *)
(*************************************************************)
begin
  inline(
    (* Parameter uebernehmen                    *)
    $e5/		(* push hl		*)
    $d5/		(* push de		*)
    $c5/		(* push bc		*)
    $dd/$e5/		(* push ix		*)
    $2a/c/		(* ld hl,(c)		*)
    $eb/		(* ex de,hl		*)
    $2a/t/		(* ld hl,(t)		*)

    (* Ton erzeugen                             *)
    $f3/		(* di			*)
    $7d/		(* ld a,l		*)
    $cb/$3d/		(* srl l		*)
    $cb/$3d/		(* srl l		*)
    $2f/		(* cpl			*)
    $e6/$03/		(* and 03h		*)
    $4f/		(* ld c,a		*)
    $06/$00/		(* ld b,00h		*)
    $dd/$21/*+7/	(* ld ix,Tabelle	*)
    $dd/$09/		(* add ix,bc		*)
    $3e/$0b/		(* ld a, 0bh		*)
    $00/		(* nop			*)

    (* Sprungtabelle: *)
    $00/		(* nop			*)
    $00/		(* nop			*)
    $04/		(* inc b		*)
    $0c/		(* inc c		*)

    (* l1: *)
    $0d/		(* dec c		*)
    $20/$fd/		(* jr nz,l1		*)
    $0e/$3f/		(* ld c,3fh		*)
    $05/		(* dec b		*)
    $20/$f8/		(* jr nz,l1		*)
    $3c/		(* inc a		*)
    $fe/$0d/		(* cp 0dh		*)
    $20/$02/		(* jr nz,l2		*)
    $3d/		(* dec a		*)
    $3d/		(* dec a		*)

    (* l2: *)
    $d3/$f8/		(* out (0f8h),a		*)
    $44/		(* ld b,h		*)
    $4f/		(* ld c,a		*)
    $fe/$0b/		(* cp 0bh		*)
    $20/$09/		(* jr nz,l3		*)
    $7a/		(* ld a,d		*)
    $b3/		(* or e			*)
    $28/$09/		(* jr z,l4		*)
    $79/		(* ld a,c		*)
    $4d/		(* ld c,l		*)
    $1b/		(* dec de		*)
    $dd/$e9/		(* jp (ix)		*)

    (* l3: *)
    $4d/		(* ld c,l		*)
    $0c/		(* inc c		*)
    $dd/$e9/		(* jp (ix)		*)

    (* l4: *)
    $fb/		(* ei			*)

    (* Alles aufraeumen                         *)
    $3e/$0c/		(* ld a,0ch		*)
    $d3/$f8/		(* out(0f8h),a		*)
    $dd/$e1/		(* pop ix		*)
    $c1/		(* pop bc		*)
    $d1/		(* pop de		*)
    $e1			(* pop hl		*)
  );
end;

procedure SpieleTon(Ton, Dauer: Integer);
(*************************************************************)
(* Spielt einen einzelnen Ton mit der vorgegebene Dauer.     *)
(* Die Toene sind durchnummeriert, jede Zahl repraesentiert  *)
(* einen der zwoelf (Halb-)Toene der Tonleiter.              *)
(* Der moegliche Tonumfang umfasst zwei Oktaven (0 - 24)     *) 			
(*                                                           *)
(* Die Array-Bezeichner stammen aus dem originalen           *)
(* BASIC-Programm:                                           *)
(* tval ist mir noch unklar, cps ist evtl. eine Frequenz     *)
(* Fuer jede Note (0-24 entspricht C - C") gibt es ein Paar  *)
(* (tval/cps), mit dem die Sound-Routine aufgerufen wird.    *)
(*************************************************************)
const
  tval : TArray25 = (3324,3132,2961,2789,2636,2485,2350,2227,
                     2098,1994,1863,1770,1655,1564,1473,1391,
                     1311,1258,1167,1101,1039,979,924,877,819);
  cps :  TArray25 = (131,139,147,156,165,175,185,196,
                     208,220,233,247,262,277,294,311,
                     330,349,370,392,415,440,466,493,524);
var
  t, c: Integer;
begin
  t := tval[Ton];
  c := cps[Ton] div 8 * Dauer;
  Sound(t,c);
end;

procedure SpieleOktaven;
(*************************************************************)
(* Diese Prozedur spielt die beiden verfuegbaren Oktaven mit *)
(* (im Gegensatz zum Original) konstanter Tonlaenge 3.       *)
(*************************************************************)
const
(* Notenwerte:       C D E F G A  H  C  D  E  F  G  A  H  C  *)
  Oktaven: TNoten = (0,2,4,5,7,9,11,12,14,16,17,19,21,23,24);
var
  i: Integer;
begin
  WriteLn('Die erste Oktav');
  for i := 0 to 7 do
    SpieleTon(Oktaven[i],3);

  WriteLn('Die zweite Oktav');
  for i := 7 to 14 do
    SpieleTon(Oktaven[i],3);
end;

procedure SpieleMelodie(Melodie: TStr60);
(*************************************************************)
(* Diese Prozedur spielt eine vorgegebene Melodie ab, die    *)
(* in Form von Noten (C, D etc.) uebergeben wird.            *)
(*************************************************************)
var
  i: Integer;
  c: Char;
  Ton: Integer;
  Dauer: Integer;
  Oktav: Integer;

  function Wert(c: Char): Integer;
  begin
    Wert := ord(c)-ord('0');
  end;

begin
  i := 1;
  while i<=length(Melodie) do
  begin
    c := Melodie[i];
    if c='R' then
    begin
      (* R = Pause, naechste Ziffer gibt die Dauer an *)
      Pause(Wert(Melodie[i+1]));
    end else
    if c='O' then
    begin
      (* O = Oktavauswahl, naechste Ziffer gibt die Oktav an (1 oder 2) *)
      Oktav := Wert(Melodie[i+1]);
    end else
    begin
      (* Ansonsten Note mit optionalem b oder # sowie Laenge *)
      (* Bestimmung des Halbtons aus der Note und evtl. b/#  *)
      Ton := Pos(c,'D_EF_G_A_BC')-1;
      if Oktav=2 then Ton := Ton + 12;
      if Melodie[i+1]='#' then
      begin
        Ton := Ton + 1;
        i := i + 1;
      end;
      if Melodie[i+1]='b' then
      begin
        Ton := Ton - 1;
        i := i+1;
      end;
      Dauer := Wert(Melodie[i+1]);
      SpieleTon(Ton, Dauer);
    end;
    i := i + 2;
  end;
end;

begin
  (*SpieleOktaven;

  Pause(20);

  WriteLn;
  WriteLn('Melodie:');
  WriteLn('Rule Britannia!');*)
  Case stueck Of
	1:SpieleMelodie('O2E8E3F3F6E3F4E1D3O1C3B9B3O2G5F5E1D1E1F1G3F3E6D6O1C9');
	2:Begin
		(*WriteLn('Freude schoener Goetterfunken');*)
		SpieleMelodie('O2E4E4F4G4G4F4E4D4O1C4C4O2D4E4E4D4D8');
		SpieleMelodie('O2E4E4F4G4G4F4E4D4O1C4C4O2D4E4D4O1C2C8');
		SpieleMelodie('O2D4D4E4O1C4O2D4E2F2E4O1C4O2D4E2F2E4D4O1C4O2D4E8');
		SpieleMelodie('O2E4F4G4G4F4E4D4O1C4C4O2D4E4D4O1C2C8');
	End;
		3:SpieleMelodie('O1C8O2F8F8H8O1C8O2Fb8');
  End;
end;