 ; Transformator BASICODE-ASCII -> OMIKRON-BASIC

         text

 ; Disketten-Dateinamen erfragen

         pea       dat_ask(pc)    ; Anfangsmeldung auf den Bildschirm bringen
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         lea       buffer(pc),a3  ; Hier soll der Name hin
         move.l    a3,-(sp)
         move      #$a,-(sp)
         trap      #1
         addq.l    #6,sp
         tst       d0             ; Dateiname eingegeben ?
         beq       ende           ; Wenn nicht, dann Abbruch


 ; Floppy A anwhlen

         clr       -(sp)
         move      #$e,-(sp)      ; GEMDOS-SETDRV
         trap      #1
         addq.l    #4,sp


 ; SFIRST

         lea       pointer(pc),a4  ; Disk-Transfer-Puffer setzen
         move.l    a4,-(sp)
         move      #$1a,-(sp)
         trap      #1
         addq.l    #6,sp
         move      #1,-(sp)       ; normaler Zugriff, schreibgeschtzt
         addq.l    #2,a3
         move.l    a3,-(sp)       ; Filename, nach dem gesucht werden soll
         move      #$4e,-(sp)     ; GEMDOS-SFIRST
         trap      #1
         adda      #8,sp
         tst       d0
         bmi       floperror


 ; Datei ffnen

         clr       -(sp)          ; Datei nur lesen
         movea.l   a4,a5
         adda      #30,a5         ; Name und Extension der Datei
         move.l    a5,-(sp)
         move      #$3d,-(sp)     ; GEMDOS-OPEN
         trap      #1
         adda      #8,sp
         tst       d0
         bmi       floperror
         move      d0,d5          ; Handle-Nummer sichern


 ; Datei lesen
         lea       beginn(pc),a5
         move.l    a5,-(sp)       ; Adresse des Datenpuffers
         adda      #26,a4
         move.l    (a4),d4        ; Gre der Datei (aus SFIRST)
         move.l    d4,-(sp)
         move      d5,-(sp)       ; Handle-Nummer
         move      #$3f,-(sp)     ; GEMDOS-READ
         trap      #1
         adda      #12,sp
         tst.l     d0
         bmi       floperror


 ; Datei schlieen

         move      d5,-(sp)       ; Handle-Nummer
         move      #$3e,-(sp)     ; GEMDOS-CLOSE
         trap      #1
         addq.l    #4,sp
         tst       d0
         bmi       floperror

 ; Zieldatei-Namen erfragen

         pea       datask1(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         pea       buffer(pc)
         move      #$a,-(sp)
         trap      #1
         addq.l    #6,sp
         tst       d0
         beq       ende

 ; Meldung ausgeben

         pea       meldung(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp







 ; Hier eine bersicht der verwendeten Register:
 ;
 ; A4    Zeiger auf Inhalt der Analyse-Tabelle
 ;       Die Analyse-Tabelle ist nach folgendem Schema aufgebaut:
 ;       1. Byte   : Position des ersten Bytes hinter dem Schlsselwort relativ
 ;                   zum letzten Schlsselwort (am Anfang relativ zur
 ;                   Startadresse der Quelldatei)
 ;       2. Byte   : Lnge des Schlsselwortes
 ;       3. Byte   : Bit 0: gesetzt, wenn rechts vom Schl.w. kein SPACE vorhanden
 ;                   Bit 1: gesetzt, wenn links vom Schl.w.  kein SPACE vorhanden


 ; A5    Zeiger auf RAM-Position innerhalb der Quelldatei
 ;
 ; A6    Adresse des ersten Bytes hinter dem letzten gefundenen
 ;       Schlsselwort in der Quelldatei

 ; D3    Schlsselwortlnge des gerade gescannten Wortes
 ; D6    Anzahl der gefundenen Schlsselwrter in der Quelldatei



 ; SWORT Tabelle der Schlsselwrter, Aufbau:
 ;       1 Byte: Lnge des Schlsselwortes
 ;               Schlsselwort
 ;
 ; SADRTAB Adre-Tabelle zur Schlsselwort-Tabelle SWORT
 ;

         lea       beginn(pc),a5  ; Anfang der BASICODE-Datei auf Diskette
         movea.l   a5,a6
         move.l    d4,d7          ; Lnge der Zieldatei=Lnge der Quelldatei
         move.l    a5,d6          ; Anfang der Quelldatei
         add.l     d4,d6          ; + Lnge der Quelldatei
         addi.l    #$10000,d6     ; + 64K Raum fr zustzliche SPACES
         clr.b     d6             ; Anfang der Analysetabelle auf
         movea.l   d6,a4          ; gerade Adresse
         clr.l     d6
scheck   lea       swort(pc),a2   ; Zeiger auf die Schlsselwort-Tabelle
         lea       sadrtab(pc),a3 ; und die zugehrige Sprungtabelle
         moveq     #59,d1         ; Anzahl der vorhandenen Schlsselwrter
                                  ; - 1 fr DBRA
nexword  movea.l   a5,a1          ; Zeiger auf aktuelle Position in der Quelldatei
         clr.l     d2
         move.b    (a2)+,d2       ; Lnge des Tabellen-Schlsselwortes
         move.l    d2,d3          ; sichern fr sptere Verwendung
         subq.l    #1,d2          ; .... fr DBRA
cmpbyte  cmpm.b    (a2)+,(a1)+    ; Tabellen-Schlsselwort mit Zeichenkette
         beq.s     rightbyte      ; in der Quelldatei vergleichen
         bcs.s     nexram         ; schon zu weit in der Tabelle ?
         addq.l    #4,a3          ; Adrezeiger auf nchste Schl.wort-adr.
         adda      d2,a2          ; String-Zeiger auf nchstes Schlsselwort
         dbra      d1,nexword

 ; An dieser Position der Quelldatei beginnt kein Schlsselwort

nexram   addq.l    #1,a5          ; nchstes Byte der Quelldatei bearbeiten
nexram1  subq.l    #1,d4          ; Counter dekrementieren
         bne       scheck

         bra       shiftprg       ; Analyse beendet, nun Programm verschieben

rightbyte dbra     d2,cmpbyte     ; nchstes Zeichen mit dem Schlsselwort
                                  ; vergleichen
         movea.l   (a3),a3
         jmp       (a3)           ; Springe zur dem Schlsselwort entspre-
                                  ; chenden Routine


 ; Hier folgen nun die Routinen fr jedes einzelne Schlsselwort

anfstrich  move.b  (a1)+,d0       ; Lnge des Pseudo-Schl.w's anpassen
         addq      #1,d3          ; und Lngenzhler erhhen
         cmpi.b    #$22,d0        ; Ende des Strings suchen
         beq.s     lastchr        ; Abfhrungszeichen gefunden
         cmpi.b    #$27,d0
         beq.s     lastchr
         cmpi.b    #$d,d0         ; CR ?
         bne       anfstrich
         subq      #1,d3          ; Zeilenende ohne Abfhrungszeichen
         subq.l    #1,a1          ; erreicht, deshalb Suche abbrechen
lastchr  bsr       setantab
         bra       scheck

dollar   bra       nexram

hochkomma bra      anfstrich

klammer_auf bra    nexram

klammer_zu  bra    nexram

mal      bra       nexram

plus     bra       nexram

komma    bra       nexram

minus    bra       nexram

punkt    bra       nexram

durch    bra       nexram

dpunkt   bra       nexram

semikolon  bra     nexram

kleiner  bra       nexram

gleich   bra       nexram

groesser bra       nexram

frage    bsr       setantab
         bra       scheck

abs_     bsr       setantab
         bra       scheck

and_     bsr       setantab
         bra       scheck

asc_     bsr       setantab
         bra       scheck

atn_     bsr       setantab
         bra       scheck

chr_    bsr       setantab
         bra       scheck

cos_     bsr       setantab
         bra       scheck

data_    bsr       setantab
         bra       scheck

dim_     bsr       setantab
         bra       scheck

end_     bsr       setantab
         bra       scheck

exp_     bsr       setantab
         bra       scheck

for_     bsr       setantab
         bra       scheck

gosub_   bsr       setantab
         bra       scheck

goto_    bsr       setantab
         bra       scheck

if_      bsr       setantab
         bra       scheck

input_   bsr       setantab
         bra       scheck

int_     bsr       setantab
         bra       scheck

left_    bsr       setantab
         bra       scheck

len_     bsr       setantab
         bra       scheck

let_     bsr       setantab
         bra       scheck

log_     move.b    #' ',(a5)+
         move.b    #'L',(a5)+
         move.b    #'N',(a5)+
         subq.l    #3,d4
         bne       scheck
         bra       shiftprg

mid_     bsr       setantab
         bra       scheck

next_    bsr       setantab
         bra       scheck

not_     bsr       setantab
         bra       scheck

on_      bsr       setantab
         bra       scheck

or_      bsr       setantab
         bra       scheck

print_   bsr       setantab
         bra       scheck
read_    bsr       setantab
         bra       scheck

rem_     bsr       setantab
         move      #$0d0a,d1
shd2     lsl       #8,d2
         move.b    (a5)+,d2
         subq.l    #1,d4
         beq       shiftprg
         cmp       d1,d2          ;  CR ?
         bne       shd2
         bra       scheck

restore_ bsr       setantab
         bra       scheck

return_  bsr       setantab
         bra       scheck

right_   bsr       setantab
         bra       scheck

run_     bsr       setantab
         bra       scheck

sgn_     bsr       setantab
         bra       scheck

sin_     bsr       setantab
         bra       scheck

sqr_     bsr       setantab
         bra       scheck

step_    bsr       setantab
         bra       scheck

stop_    bsr       setantab
         bra       scheck

tab_     bsr       setantab
         bra       scheck

tan_     bsr       setantab
         bra       scheck

then_    bsr       setantab
         bra       scheck

to_      bsr       setantab
         bra       scheck

val_     bsr       setantab
         bra       scheck

potenz   bsr       setantab
         bra       scheck
















 ; SETANTAB trgt die Informationen ber
 ;
 ;       relative Position des ersten Bytes hinter dem Schlsselwort
 ;       zum gleichen Byte hinter dem vergangenen Schlsselwort (1 Wort),
 ;
 ;       Lnge des Schlsselwortes (1 Byte)  ,
 ;
 ;       Fehlen von linken (Bit 1) und rechten (Bit 0) SPACES (1 Byte) ,
 ;
 ; in die Analyse-Tabelle, auf die A4 zeigt, ein.

setantab addq.l    #1,d6          ; Schlsselwort-Zhler erhhen
         move.l    a1,d0          ; erstes Byte hinter Schl.wort
         sub.l     a6,d0          ; - Abstand zum letzten Schl.wort
         move      d0,(a4)+       ; = relative Position zum letzten Schl.wort
         movea.l   a1,a6          ; erstes Byte hinter Schl.wort
         move.b    d3,(a4)+       ; Lnge des Schl.wortes eintragen
         clr       d0
         cmpi.b    #$20,-1(a5)    ; SPACE links vom Schl.wort ?
         beq.s     recheck
         bset      #1,d0          ; nein
         addq.l    #1,d7          ; Lnge der Zieldatei anpassen
recheck  cmpi.b    #$20,(a1)      ; SPACE rechts vom Schl.wort ?
         beq.s     regset
         bset      #0,d0          ; nein
         addq.l    #1,d7          ; Lnge der Zieldatei anpassen
regset   move.b    d0,(a4)+       ; in die Analysetabelle eintragen
         movea.l   a1,a5          ; Quelldatei-Zeiger und
         sub.l     d3,d4          ; Counter aktualisieren
         beq.s     st_manip       ; Subroutine annullieren
         rts
st_manip addq.l    #4,a7          ; Stack in Ordnung bringen
         bra       shiftprg



 ; SHIFTPRG verschiebt die Quelldatei gem Analyse-Tabelle

shiftprg lea       beginn(pc),a3  ; Anfang der Quelldatei
         adda.l    d7,a3          ; + Lnge der Zieldatei
                                  ; = 1. Byte hinter der Zieldatei
neuseq   subq.l    #1,d6          ; Analyse-Tab.-Counter dekrementieren
         bcs       savebas        ; Wenn fertig, dann abspeichern
         clr       d1
         move.b    -(a4),d2       ; SPACE-Register
         move.b    -(a4),d1       ; Lnge des Schl.w.'s
         move      -(a4),d0       ; Relative Lage des Bytes hinter dem SW
                                  ; zum entsprechenden Byte des folgenden SW
         movea.l   a6,a1          ;
         suba      d0,a1          ; nchster Wert fr A6
         move.l    a5,d3          ;  A5 (1. Byte hinter Quelldatei)
         sub.l     a6,d3          ; -A6 (1. Byte hinter SW)
                                  ; = Anzahl der zu verschiebenden
                                  ; Bytes rechts vom SW

         beq.s     respa          ; kein Byte rechts zu verschieben
         subq      #1,d3          ; fr DBRA passend machen
copyrechts move.b  -(a5),-(a3)    ; Teil rechts vom SW verschieben
         dbra      d3,copyrechts
respa    btst      #0,d2          ; SPACE rechts vom SW vorhanden ?
         beq       swshift        ; ja
         move.b    #$20,-(a3)     ; nein, also SPACE einfgen
swshift  subq      #1,d1          ; fr DBRA
copysw   move.b    -(a5),-(a3)    ; SW verschieben
         dbra      d1,copysw
         btst      #1,d2          ; SPACE links vom SW vorhanden ?
         beq.s     neublock       ; ja
         move.b    #$20,-(a3)     ; nein, also SPACE einfgen
neublock movea.l   a1,a6          ; Zeiger auf Byte hinter nchstem SW
         bra       neuseq         ; The same procedure as last year ?
                                  ; The same procedure as every year !

 ; SAVEBAS speichert die Zieldatei auf Disk A ab

savebas  clr       -(sp)          ; Datei anmelden
         lea       buffer(pc),a6
         addq.l    #2,a6
         move.l    a6,-(sp)
         move      #$3c,-(sp)
         trap      #1
         adda      #8,sp
         tst       d0
         bmi       floperror

         pea       subrout(pc)    ; Datei schreiben, Start
         addi.l    #beginn,d7     ; Lnge der Unterprogramme
         subi.l    #subrout,d7    ; + Lnge der Zieldatei
         move.l    d7,-(sp)       ;
         move      d0,-(sp)       ; Handle
         move      #$40,-(sp)
         trap      #1
         adda      #12,sp
         tst       d0
         bmi       floperror

         bra       ende

 ; EINGABE schreibt eine 0-terminierte Zeichenkette ab A1 auf den Bildschirm,
 ; wartet auf ein Zeichen von der Tastatur und gibt dieses in D0 zurck

eingabe  move.l    a1,-(sp)
         move      #9,-(sp)       ; GEMDOS PRINT LINE
         trap      #1
         addq.l    #6,sp
         move      #1,-(sp)       ; GEMDOS CONIN
         trap      #1
         addq.l    #2,sp
         rts



 ; Floppy-Fehler aufgetreten

floperror lea      errtab(pc),a0
         eori      #$ffff,d0
         subi      #31,d0
         tst       d0
         beq       errout
         subq      #1,d0
suchnull tst.b     (a0)+
         bne       suchnull
         dbra      d0,suchnull
errout   move.l    a0,-(sp)
         move      #9,-(sp)
         trap      #1             ; Fehlermeldung ausgeben
         addq.l    #6,sp
         bsr       pause
         bra       ende


ende     clr.w     -(sp)          ; GEMDOS-TERM
         trap      #1

pause    pea       pausetxt(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
psewait  move.b    #1,-(sp)       ; GEMDOS CONIN
         trap      #1
         addq.l    #2,sp
         cmpi.b    #$20,d0
         bne       psewait
         rts

         data
pausetxt dc.b      $d,$a,'                    Bitte (SPACE) drcken !',$d,$a,0
errtab   dc.b      "ungltige Funktionsnummer",0,"Datei nicht gefunden",0
         dc.b      "Pfadname nicht gefunden",0,"zu viele offene Dateien",0
         dc.b      "Zugriff nicht mglich",0,"ungltige Handle-Nummer",0,0
         dc.b      "nicht gengend Speicher vorhanden",0,"ungltige Speicherblockadresse",0,0,0,0,0,0
         dc.b      "ungltige Laufwerksbezeichnung",0,0,0,"keine weiteren Dateien",0

dat_ask  dc.b      $1b,'b0',$1b,'c1',$1b,'E'
         dc.b      'Transformator BASICODE-ASCII -> OMIKRON-BASIC (Dezember 1988)',$d,$a
         dc.b      '-------------------------------------------------------------',$d,$a,$a
         dc.b      'Autor: Thomas Murer, Duisburger Str. 296, D-4200 Oberhausen 1',$d,$a,$a,$a
         dc.b      'Dieses Programm trennt die BASICODE-Befehle durch Einfgen von',$d,$a
         dc.b      'Blanks und ersetzt das LOG aus BASICODE durch Ln. Es fgt auerdem',$d,$a
         dc.b      'die fr den Atari ST spezifischen BASICODE-Unterprogramme hinzu.',$d,$a
         dc.b      'Erwartet wird eine beschreibbare Diskette mit einem zu konver-',$d,$a
         dc.b      'tierenden ASCII-File in Laufwerk A.',$d,$a,$a
         dc.b      'Bitte den Namen der zu konvertierenden BASICODE-DATEI eingeben:',$d,$a,0
datask1  dc.b      $d,$a,'Unter welchem Namen soll die fertige Datei abgespeichert werden ? ',$d,$a,0
meldung  dc.b      $1b,'E','Bitte etwas Geduld, Rom wurde auch nicht an einem Tag gebaut !',$d,$a,0
         dc.w      0
buffer   dc.b      12,0,0,0,0,0,0,0,0,0,0,0,0,0,0
pointer  ds.l      11

 ; Es folgen nun die 60 BASICODE Schlsselwrter nebst ihrer Lnge
 ; in der Reihenfolge ihrer ASCII-Codes

swort    dc.b      1,$22          ; "
         dc.b      1,'$'
         dc.b      1,$27          ; '
         dc.b      1,'('
         dc.b      1,')'
         dc.b      1,'*'
         dc.b      1,'+'
         dc.b      1,','
         dc.b      1,'-'
         dc.b      1,'.'
         dc.b      1,'/'
         dc.b      1,':'
         dc.b      1,';'
         dc.b      1,'<'
         dc.b      1,'='
         dc.b      1,'>'
         dc.b      1,'?'
         dc.b      3,'ABS'
         dc.b      3,'AND'
         dc.b      3,'ASC'
         dc.b      3,'ATN'
         dc.b      4,'CHR$'
         dc.b      3,'COS'
         dc.b      4,'DATA'
         dc.b      3,'DIM'
         dc.b      3,'END'
         dc.b      3,'EXP'
         dc.b      3,'FOR'
         dc.b      5,'GOSUB'
         dc.b      4,'GOTO'
         dc.b      2,'IF'
         dc.b      5,'INPUT'
         dc.b      3,'INT'
         dc.b      5,'LEFT$'
         dc.b      3,'LEN'
         dc.b      3,'LET'
         dc.b      3,'LOG'
         dc.b      4,'MID$'
         dc.b      4,'NEXT'
         dc.b      3,'NOT'
         dc.b      2,'ON'
         dc.b      2,'OR'
         dc.b      5,'PRINT'
         dc.b      4,'READ'
         dc.b      3,'REM'
         dc.b      7,'RESTORE'
         dc.b      6,'RETURN'
         dc.b      6,'RIGHT$'
         dc.b      3,'RUN'
         dc.b      3,'SGN'
         dc.b      3,'SIN'
         dc.b      3,'SQR'
         dc.b      4,'STEP'
         dc.b      4,'STOP'
         dc.b      3,'TAB'
         dc.b      3,'TAN'
         dc.b      4,'THEN'
         dc.b      2,'TO'
         dc.b      3,'VAL'
         dc.b      1,'^'

sadrtab  dc.l      anfstrich,dollar,hochkomma,klammer_auf,klammer_zu,mal
         dc.l      plus,komma,minus,punkt,durch,dpunkt,semikolon,kleiner
         dc.l      gleich,groesser,frage
         dc.l      abs_,and_,asc_,atn_,chr_,cos_,data_
         dc.l      dim_,end_,exp_,for_,gosub_,goto_,if_
         dc.l      input_,int_,left_,len_,let_,log_,mid_
         dc.l      next_,not_,on_,or_,print_,read_,rem_
         dc.l      restore_,return_,right_,run_,sgn_,sin_,sqr_
         dc.l      step_,stop_,tab_,tan_,then_,to_,val_
         dc.l      potenz


 ; Hier folgen nun die Omikron-spezifischen Unterprogramme
 ; in den BASICODE-Zeilen 0-999

subrout  dc.b '0 REM BASICODE-Unterprogramme von Thomas Murer, Duisburger Str. 296, D-42 OB 1',$d,$a
         dc.b '10 DEFSNG ',$22,'A-Z',$22,': SCREEN 1: MODE ',$22,'USA',$22,': CLS: GOTO 1000',$D,$A
         DC.B '20 GOTO 1010',$D,$A
         DC.B '100 CLS : RETURN',$D,$A
         DC.B '110 IF Ve>24 OR Ho >79 THEN RETURN',$D,$A
         DC.B '111 PRINT @(Ve,Ho);: RETURN',$D,$A
         DC.B '120 Ho= POS(0):Ve= CSRLIN -1: RETURN',$D,$A
         DC.B '200 In$= INKEY$ : IF In$<>',$22,$22,' THEN In$= CHR$( CVIL(In$) AND $FF)',$D,$A
         DC.B '205 RETURN',$D,$A
         DC.B '210 In$= INPUT$(1): RETURN',$D,$A
         DC.B '250 PRINT CHR$(7);: RETURN',$D,$A
         DC.B '260 Rv= RND(1): RETURN',$D,$A
         DC.B '270 Fr=FRE(0): RETURN',$D,$A
         DC.B '300 Sr$= RIGHT$( STR$(Sr), LEN( STR$(Sr))+( LEFT$( STR$(Sr),1)=',$22,$20,$22,')): RETURN',$D,$A
         DC.B '310 Sr$=',$22,$22,': IF Sr >=10^(Ct-Cn- SGN(Cn)) THEN GOTO 318',$D,$A
         DC.B '311 IF Sr<-.5*10^-Cn THEN SR$=',$22,'-',$22,$D,$A
         DC.B '312 Sr$=Sr$+ MID$( STR$( INT( ABS(Sr)+.5*10^-Cn)),2)',$d,$a
         dc.b '313 IF LEN(Sr$)<Ct-Cn+(Cn<>0) THEN Sr$=SPC(Ct-Cn+(Cn<>0)-LEN(Sr$))+Sr$',$d,$a
         dc.b '314 IF Cn=0 OR ABS(Sr)>=1E+10 THEN GOTO 316',$D,$A
         DC.B '315 Sr$=Sr$+ MID$( STR$(1+ ABS(Sr)- INT( ABS(Sr))+.5*10^-Cn),3,Cn+1)',$d,$a
         dc.b '316 IF LEN(Sr$)<Ct THEN Sr$=Sr$+SPC(Ct - LEN(Sr$))',$d,$a
         dc.b '317 IF LEN(Sr$)>Ct THEN Sr$=',$22,$22,$d,$a
         dc.b '318 IF LEN(Sr$)<Ct THEN Sr$=Sr$+',$22,'*',$22,'*( Ct- LEN(Sr$))',$d,$a
         dc.b '319 RETURN',$D,$A
         DC.B '350 LPRINT Sr$;: RETURN',$D,$A
         DC.B '360 LPRINT : RETURN'
beginn   dc.b      1
         end
 