 ; BASIC-Programme in BASICODE-Programme konvertieren (Disk -> Kassette)

         text

         move      #$20,-(sp)     ; Supervisor-Modus einschalten
         trap      #1
         addq.l    #6,sp
         movea.l   d0,a2          ; User Stack sichern

 ; Disketten-Dateinamen erfragen

         pea       dat_ask(pc)    ; Anfangsmeldung auf den Bildschirm bringen
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         lea       buffer(pc),a3  ; Hier soll der Name hin
         move.l    a3,-(sp)
         move      #$a,-(sp)
         trap      #1
         addq.l    #6,sp
         tst       d0             ; Dateiname eingegeben ?
         beq       ende           ; Wenn nicht, dann Abbruch


 ; Floppy A anwhlen

         clr       -(sp)
         move      #$e,-(sp)      ; GEMDOS-SETDRV
         trap      #1
         addq.l    #4,sp


 ; SFIRST

         lea       beginn(pc),a4  ; Disk-Transfer-Puffer setzen
         move.l    a4,-(sp)
         move      #$1a,-(sp)
         trap      #1
         addq.l    #6,sp
         move      #1,-(sp)       ; normaler Zugriff, schreibgeschtzt
         adda.l    #2,a3
         move.l    a3,-(sp)       ; Filename, nach dem gesucht werden soll
         move      #$4e,-(sp)     ; GEMDOS-SFIRST
         trap      #1
         adda.l    #8,sp
         tst       d0
         bmi       floperror


 ; Datei ffnen

         clr       -(sp)          ; Datei nur lesen
         movea.l   a4,a5
         adda.l    #30,a5         ; Name und Extension der Datei
         move.l    a5,-(sp)
         move      #$3d,-(sp)     ; GEMDOS-OPEN
         trap      #1
         adda.l    #8,sp
         tst       d0
         bmi       floperror
         move      d0,d5          ; Handle-Nummer sichern


 ; Datei lesen

         move.l    a4,-(sp)       ; Adresse des Datenpuffers
         movea.l   a4,a5
         adda.l    #26,a5
         move.l    (a5),d4        ; Gre der Datei (aus SFIRST)
         move.l    d4,-(sp)
         move      d5,-(sp)       ; Handle-Nummer
         move      #$3f,-(sp)     ; GEMDOS-READ
         trap      #1
         adda.l    #12,sp
         tst.l     d0
         bmi       floperror


 ; Datei schlieen

         move      d5,-(sp)       ; Handle-Nummer
         move      #$3e,-(sp)     ; GEMDOS-CLOSE
         trap      #1
         addq.l    #4,sp
         tst       d0
         bmi       floperror


 ; Zeile 1000 im RAM suchen, denn die systemspezifischen Subroutinen sollen
 ; nicht auf's Band

         move.l    #$31303030,d0  ; ASCII '1000'
         cmp.l     (a4),d0        ; Wenn das Programm schon mit Zeile 1000
         beq       found1000      ; beginnt, dann nach found1000,
         move      #$0d0a,d1      ; ansonsten nach Kombination CR LF suchen
suchcrlf lsl       #8,d2          ; Vergleichswert
         move.b    (a4)+,d2
         cmp       d1,d2
         beq       crlf
nochsuch subq.l    #1,d4
         bne       suchcrlf

         pea       z1000f(pc)     ; Zeile 1000 existiert nicht !
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         moveq     #20,d1
         bsr       pause
         bra       ende

crlf     movea.l   a4,a6
         moveq     #3,d3
shift    lsl.l     #8,d2
         move.b    (a6)+,d2
         dbra      d3,shift
         cmp.l     d0,d2          ; '1000' ?
         bne       nochsuch

found1000 movea.l  a4,a5
         lea       ramstart(pc),a0
         move.l    a5,(a0)
         lea       datlaenge(pc),a0
         move.l    d4,(a0)
         lea       $fffc02,a1     ; ACIA
         clr.l     -(sp)
         ori       #$700,sr       ; Interrupts ausschalten

 ; Jetzt soll der Recorder eingeschaltet werden

save     pea       recon(pc)      ; Aufforderung zum Einschalten des Recorders
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
zeich    move.b    (a1),d0        ; Auf Eingabe warten
         cmpi.b    #$39,d0        ; Space ?
         bne       zeich
         pea       online(pc)     ; Eingabe quittieren
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp


 ; Initialisierung

         lea       $484,a0        ; System-Variable CONTERM
         clr.b     (a0)
         lea       $ff8800,a3     ; PSGA
         lea       $ff8802,a4     ; PSGD
         lea       $fffa1f,a6     ; TADR
         clr.b     (a3)           ; Frequenz Tonkanal A
         clr.b     (a4)           ; maximal
         move.b    #7,(a3)        ; Ton-Kanal A einschalten,
         move.b    #$fe,(a4)      ; Ports A und B als Ausgabekanle

 ; MFP-Timer-Interrupt installieren

         lea       vector(pc),a0  ; alte Adresse des Timer-A Interrupts
         move.l    $134,(a0)      ; in mfpvek sichern
         lea       mfpint(pc),a0  ; neue Adresse einschreiben
         move.l    a0,$134
         lea       iera(pc),a0    ; alte Interrupt-Enable-Register sichern
         move.l    $fffa06,(a0)
         move.l    #$200000,d0    ; Timer-A enablen, alle anderen
         move.l    d0,$fffa06     ; MFP-Interrupts disablen
         move.l    d0,$fffa12     ; Interrupt-Mask-Register entsprechend
         move.b    #$ff,(a6)      ; Datenregister des Timers A vorbesetzen
         move.b    #$40,$fffa17   ; Automatic End-of-Interrupt-Modus
         move.b    #2,$fffa19     ; TACR: Vorteiler = 10
         clr.l     $fffa0a        ; Interrupt-Pending
         clr.l     $fffa0e        ; Interrupt-Service
         eori      #$300,sr       ; MFP-Interrupt freigeben

         ; Folgende Register drfen nun nicht mehr verndert werden:
         ; A1      ACIA
         ; A2      alter Stack
         ; A3      PSGA
         ; A4      PSGD
         ; A6      TADR
         ;
         ; Folgende Register erfllen bereits eine bestimmte Aufgabe:
         ;
         ; A5      Zeiger auf Datenbytes
         ; D4      Anzahl der noch zu bertragenden Daten-1


         movea.l   $44e,a0        ; logical screenbase
         moveq     #1,d5          ; 2400 Hz
         move      #6100,d0       ; 5 Sekunden + Sicherheitsreserve
leader   bsr       bit            ; lang ausgeben.
         dbra      d0,leader
         moveq     #2,d1          ; STX
         bsr       byte

 ; Nun wird der eigentliche Text bertragen

escape   cmpi.b    #1,(a1)        ; Taste ESC gedrckt ?
         beq       endws
         move.b    (a5)+,d1
         cmpi.b    #$a,d1         ; LF darf nicht bertragen werden!
         beq       outend
         bsr       byte
outend   subq.l    #1,d4
         bne       escape

         moveq     #3,d1          ; ETX
         bsr       byte
         moveq     #1,d5          ; 2400 Hz
         move      #6100,d0       ; 5 Sekunden + Sicherheitsreserve
trailer  bsr       bit            ; lang ausgeben
         dbra      d0,trailer


endws    ori       #$700,sr       ; disable interrupts
         lea       iera(pc),a0    ; Register restaurieren
         move.l    (a0),$fffa06
         move.l    (a0),$fffa12
         move.b    #$48,$fffa17   ; Software End-of-Interrupt-Modus
         lea       vector(pc),a0
         move.l    (a0),$134

menue    ori       #$700,sr
         lea       $fffc02,a1     ; ACIA
         lea       ramstart(pc),a0
         move.l    (a0),a5
         lea       datlaenge(pc),a0
         move.l    (a0),d4
         pea       mentxt(pc)     ; Mentext ausgeben
         move      #9,-(sp)       ; GEMDOS-PRINT-LINE
         trap      #1
         addq.l    #6,sp
meninp   move.b    (a1),d0        ; Scan-Code von Tastatur holen
         cmpi.b    #$2f,d0        ; Taste V
         beq       verify
         cmpi.b    #$1f,d0        ; Taste S
         beq       save
         cmpi.b    #$12,d0        ; Taste E
         bne       meninp
         bra       ende

verify   pea       vetxt(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         move.b    #7,(a3)
         move.b    (a3),d0        ; Alte Registerdaten auslesen,
         ori       #$3f,d0        ; ndern
         eori      #$1,d0         ; und
         move.b    d0,(a4)        ; zurckschreiben.
         move.b    #8,(a3)        ; Lautstrke-Register Kanal A anwhlen
         lea       $fffa00,a1     ; I/O-Port

vanfang  move      #5999,d2       ; Header suchen
vheader  bsr       vbit
         cmpi      #15,d5
         bne       vanfang
         dbra      d2,vheader
vlowsuch bsr       vbit           ; 2 Low-Bits suchen
         tst       d5
         bne       vlowsuch
         bsr       vbit
         tst       d5
         bne       mismatch
         bsr       vbit
         cmpi      #15,d5         ; 1 High-Bit
         bne       mismatch
         moveq     #4,d2          ; 5 Low-Bits
vlow     bsr       vbit
         tst       d5
         bne       mismatch
         dbra      d2,vlow
         moveq     #2,d2          ; 3 High-Bits
vhigh    bsr       vbit
         cmpi      #15,d5
         bne       mismatch
         dbra      d2,vhigh

         ; Nun kommt der eigentliche BASIC-Text, was auch
         ; angezeigt werden soll.....

         movea.l   $44e,a0        ; logical screenbase
vbasic   bsr       vbyte
         cmpi      #1,d5          ; Fehler aufgetreten ?
         bne       vnobug

mismatch pea       mismtxt(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         bsr       pause
         bra       menue

vnobug   cmp.b     (a5)+,d1
         bne       mismatch
         cmpi.b    #$d,d1         ; CR ?
         bne       vlpend
         adda.l    #1,a5          ; LF ignorieren
         subq.l    #1,d4
vlpend   subq.l    #1,d4
         bne       vbasic

         bsr       vbyte
         cmpi      #3,d1          ; ETX ?
         bne       mismatch
         move      #5999,d2
vtrailer bsr       bit
         cmpi      #15,d5
         bne       mismatch
         dbra      d2,vtrailer

         ; Bildschirm restaurieren

         pea       okmeldung(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         bsr       pause
         bra       menue

 ; VBYTE montiert ein Byte D1 aus:
 ;
 ; 1 Startbit  (logisch 0, 1200 Hz)
 ; 7 Datenbits (LSB zuerst)
 ; 3 Stoppbits

vbyte    bsr       vbit
         tst       d5             ; Startbit
         bne       vbytef
         moveq     #6,d2          ; 7 Datenbits
         clr       d1
vbyte1   bsr       vbit
         cmpi      #1,d5
         beq       vbyteend
         lsr.b     #1,d1
         tst       d5
         beq       vnoset
         bset      #6,d1
vnoset   dbra      d2,vbyte1
         moveq     #2,d2          ; 3 Stoppbits
vstoppb  bsr       vbit
         cmpi      #15,d5
         bne       vbytef
         dbra      d2,vstoppb
vbyteend move.b    d1,(a0)+       ; Ausgabe auf den Bildschirm
         rts

vbytef   moveq     #1,d5
         rts



 ; VBIT holt ein Bit von CTS
 ; Rckgabewert D5: 15 fr 2400 Hz (logisch 1), 0 fr 1200 Hz (logisch 0)

vbit     clr       d3             ; Flag fr Schleifenwiederholung bei 2400 Hz
         move      (a1),d6        ; Port auslesen
         andi      #4,d6          ; CTS maskieren
vbit2    move      (a1),d5
         andi      #4,d5
         cmp       d5,d6
         beq       vbit2
         clr       d6
         btst      #2,d5
         beq       vsound1
         moveq     #15,d6
vsound1  move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; alten Flankenwert sichern
         clr       d7             ; "Timer" zurcksetzen
vbit1    move      (a1),d5
         andi      #4,d5
         addq      #1,d7
         cmp       d5,d6
         beq.s     vbit1
         clr       d6
         btst      #2,d5
         beq       vsound2
         moveq     #15,d6
vsound2  move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; alten Flankenwert sichern
         clr       d5
         cmpi      #65,d7         ; 1200 Hz ?
         bcc       vhz1200
         move      #15,d5         ; Frequenz = 2400 Hz
         tst       d3             ; schon eine Schleife gedreht ?
         bne       vhz1200
         moveq     #1,d3          ; Flag setzen
         bra       vbit2
vhz1200  rts




 ; BYTE schickt ein Byte in D1 mit Start- und Stoppbits auf die Ports
 ; Ein fertiges "Byte" besteht hinterher aus:
 ;
 ; 1 Startbit  (logisch 0, 1200 Hz)
 ; 7 Datenbits (LSB zuerst        )
 ; 3 Stoppbits (logisch 1, 2400 Hz)
 ;
 ; unmittelbar verwendete Register: D1, D2, D5

byte     clr       d5             ; 1 Startbit
         bsr       bit
         move.b    d1,(a0)+       ; Byte auf den Bildschirm ausgeben
         move      d1,d5
         moveq     #6,d2          ; 7 Datenbits
byte1    bsr       bit
         lsr       #1,d5
         dbra      d2,byte1
         moveq     #1,d5
         moveq     #2,d2          ; 3 Stoppbits
byte2    bsr       bit
         dbra      d2,byte2
         rts


 ; BIT schreibt Bit 0 in D5 auf Cassette und Tongenerator
 ;
 ; Auer D5 werden folgende Register benutzt:
 ;
 ; D3    Flag fr Schleifenwiederholung bei 2400 Hz (2 Perioden !)
 ; D6    Kopie des Status-Registers
 ; D7    Flankenlnge (entspricht der jeweiligen Frequenz)

bit      clr       d3             ; Wiederholungs-Flag lschen
         moveq     #104,d7         ; Flankenwert fr 1200 Hz
         btst      #0,d5
         beq       hz1200
         lsr       #1,d7          ; Flankenwert fr 2400 Hz
hz1200   move.b    d7,(a6)        ; zum Timer-Datenregister schreiben
zweimal  clr       d6             ; Interrupt-Flag lschen
intwait1 tst       d6             ; Interrupt-Flag gesetzt ?
         beq       intwait1
         move.b    #14,(a3)       ; RTS-Bit ausgeben
         move.b    #8,(a4)
         move.b    #8,(a3)        ; Lautstrke
         move.b    #15,(a4)        ; high
         clr       d6             ; Interrupt-Flag lschen
intwait2 tst       d6             ; Interrupt-Flag gesetzt ?
         beq       intwait2
         move.b    #14,(a3)       ; RTS-Bit ausgeben
         clr.b     (a4)
         move.b    #8,(a3)        ; Lautstrke
         clr.b     (a4)           ; low
         btst      #0,d5          ; 2400 Hz ?
         beq       bitend
         tst       d3             ; dann berprfen, ob bereits eine Schleife
         bne       bitend         ; gedreht wurde
         moveq     #1,d3          ; Flag setzen
         bra       zweimal
bitend   rts


 ; Floppy-Fehler aufgetreten

floperror lea      errtab(pc),a0
         eori      #$ffff,d0
         subi      #31,d0
         tst       d0
         beq       errout
         subq      #1,d0
suchnull tst.b     (a0)+
         bne       suchnull
         dbra      d0,suchnull
errout   move.l    a0,-(sp)
         move      #9,-(sp)
         trap      #1             ; Fehlermeldung ausgeben
         addq.l    #6,sp
         bsr       pause
         bra.s     endeos

ende     eori      #$400,sr
endeos   move.l    a2,-(sp)       ; User-Modus einschalten
         move      #$20,-(sp)
         trap      #1
         addq.l    #6,sp
         clr.w     -(sp)          ; GEMDOS-TERM
         trap      #1

pause    pea       pausetxt(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
psewait  cmpi.b    #$39,$fffc02
         bne       psewait
         rts


 ; Timer-A-Interrupt-Routine

mfpint   moveq     #1,d6          ; Interrupt-Flag setzen
         rte

         data
pausetxt dc.b      $d,$a,'                    Bitte (SPACE) drcken !',$d,$a,0
errtab   dc.b      "ungltige Funktionsnummer",0,"Datei nicht gefunden",0
         dc.b      "Pfadname nicht gefunden",0,"zu viele offene Dateien",0
         dc.b      "Zugriff nicht mglich",0,"ungltige Handle-Nummer",0,0
         dc.b      "nicht gengend Speicher vorhanden",0,"ungltige Speicherblockadresse",0,0,0,0,0,0
         dc.b      "ungltige Laufwerksbezeichnung",0,0,0,"keine weiteren Dateien",0

dat_ask  dc.b      $1b,'b0',$1b,'c1',$1b,'E'
         dc.b      'BASIC-Konverter (Disk -> Kassette) fr Atari ST (November 1988)',$d,$a
         dc.b      '---------------------------------------------------------------',$d,$a,$a
         dc.b      'Autor: Thomas Murer, Duisburger Str. 296, D-4200 Oberhausen 1',$d,$a,$a,$a
         dc.b      'Dieses Programm wandelt ASCII-BASIC-Files in BASICODE-Programme um',$d,$a
         dc.b      'und speichert diese auf Cassette/Tonband ab. Dabei werden die system-',$d,$a
         dc.b      'spezifischen Unterprogramme in den Zeilen 0-999 nicht mitbertragen!',$d,$a
         dc.b      'Das zu konvertierende Programm mu unbedingt die BASIC-Zeile 1000 ent-',$d,$a
         dc.b      'halten.',$d,$a,$a,$a
         dc.b      'Hardware-Voraussetzungen: Die Pins 4 und 7 der Modem-Schnittstelle',$d,$a
         dc.b      'am Atari ST sind ber einen Widerstand von ca. 15 M Ohm mit dem Auf-',$d,$a
         dc.b      'nahmegert (Kassettenrecorder/Tonbandgert) zu verbinden.',$d,$a,$a
         dc.b      'Bitte das Aufnahmegert so aussteuern, da der Aufnahmepegel auf +3 dB',$d,$a
         dc.b      'liegt!',$d,$a,$a
         dc.b      'Welche BASIC-Datei (von Disk A) soll konvertiert werden ?',$d,$a,0

recon    dc.b      $1b,'E','Recorder einschalten und (SPACE) drcken !',$d,$a,0
online   dc.b      $1b,'E','Bitte nicht stren, ich bin beschftigt!',0
z1000f   dc.b      $d,$a,7,'BASIC-Zeile 1000 nicht gefunden -> Abbruch',$d,$a,0
mentxt   dc.b      $1b,'E'
         dc.b      $1b,'Y',40,62,'(V) erify'
         dc.b      $1b,'Y',43,62,'(S) ave'
         dc.b      $1b,'Y',46,62,'(E) nd',0
vetxt    dc.b      $1b,'E',$1b,'Y',44,52,'Band zum Verifizieren abfahren !',0
mismtxt  dc.b      $1b,'E',$1b,'Y',44,52,7,'Fehler beim Verifizieren -> Abbruch',0
okmeldung dc.b     $1b,'E',$1b,'Y',44,52,'Alles in Butter',0
buffer   dc.b      12,0
         dc.l      0,0,0,0

         bss
vram     ds.l      1
ramstart ds.l      1
datlaenge ds.l     1
vector   ds.l      1
iera     ds.l      1
beginn   ds.l      1

         end
 