         ; Programm zum Einlesen von BASICODE in ein BASIC-Programm

         text

         move      #2,-(sp)        ; XBIOS PHYSBASE
         trap      #14
         addq.l    #2,sp
         addi.l    #$7ff0,d0
         movea.l   d0,a7           ; Neuer Stack unterhalb PHYSTOP

         lea       beginn(pc),a5   ; Hier soll die Startadresse der Datei hin
         movea.l   a5,a0           ; sichern
         adda.l    #$104,a5        ; passend machen fr VDP
         move.l    a5,d0
         andi.l    #$ffffff00,d0
         movea.l   d0,a5
         move.l    d0,(a0)         ; tatschlichen Anfang der Datei nach BEGINN

         ; Dateinamen erfragen
         pea       dat_ask(pc)     ; Frage ausgeben
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         pea       buffer(pc)     ; Eingabe des Dateinamens
         move      #$0a,-(sp)
         trap      #1             ; Nun befindet ab der Adresse buffer+2 der Name
         addq.l    #6,sp          ; der Datei
         tst       d0             ; Eingabe erfolgt ?
         beq.s     nochar
         lea       buffer(pc),a0  ;   Wenn ja,
         addq.l    #2,a0          ;   dann
         adda      d0,a0          ;   Abschlumarke
         clr.b     (a0)           ;   setzen.

         ; Meldung ausgeben

nochar   pea       meldung(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp

         clr.l     -(sp)          ; Supervisormodus einschalten
         move      #$20,-(sp)
         trap      #1
         addq.l    #6,sp
         lea       savessp(pc),a2
         move.l    d0,(a2)        ; alten Stack sichern
         ori       #$700,sr       ; Frequenz auf Kanal A einstellen:
         dc.w      $a000          ; Line-A, Initialisierung
         move.l    8(a1),a1       ; Font-Header in A1
         move.l    76(a1),anfscan ; Zeiger auf 1. Scanline ASCII 00
         lea       $fffc02,a2     ; Tastatur
         lea       $ff8800,a3     ; PSGA
         lea       $ff8802,a4     ; PSGD
         clr.b     (a3)           ; Frequenz maximal
         clr.b     (a4)
         move.b    #7,(a3)        ; Rauschen aus
         move.b    (a3),d0        ; alte Registerdaten auslesen,
         ori       #$3f,d0        ; ndern
         eori      #$1,d0         ; und
         move.b    d0,(a4)        ; zurckschreiben
         move.b    #8,(a3)        ; Lautstrke-Register anwhlen
         lea       $fffa00,a1     ; I/O-Port
         moveq     #2,d7          ; Checksummen-Zhler mit STX vorbesetzen



anfang   move      #1000,d2       ; Header suchen
header   bsr       bit
         cmpi      #15,d5
         bne       anfang
         dbra      d2,header
lowsuch  bsr       bit            ; 2 Low Bits suchen
         tst       d5
         bne       lowsuch
         bsr       bit
         tst       d5
         bne       anfang
         bsr       bit            ; 1 High-Bit
         cmpi      #15,d5
         bne       anfang
         moveq     #4,d2
low      bsr       bit            ; 5 Low-Bits
         tst       d5
         bne       anfang
         dbra      d2,low
         moveq     #2,d2          ; 3 High-Bits
high     bsr       bit
         cmpi      #15,d5
         bne       anfang
         dbra      d2,high

         ; VRAM verschieben

         move.l    $ff8200,vram   ; Alte VRAM-Adresse sichern
         move.l    $44e,vlog  ; logical screenbase sichern
         move.l    a5,d0          ; Neue VRAM-Adresse = BASIC-Anfang
         move.l    d0,$44e        ; logical screenbase
         move.l    d0,d2
         addi.l    #30720,d2      ; Adresse der Druckzeile
         move.l    d2,line
         clr.l     prtoffs        ; Zeiger auf Zeilenanfang
         lsr.l     #8,d0
         movea.l   #$ff8200,a0
         movep     d0,1(a0)       ; Neue Adresse -> VDP

         suba.l    a0,a0          ; Fehler-Zhler zurcksetzen

basic    cmpi.b    #$61,(a2)      ; UNDO gedrckt ?
         beq       abbruch
         bsr       byte
         cmpi      #1,d5          ; Fehler aufgetreten ?
         bne.s     nobug

         ; Fehlerbehandlung ermglicht unter Verlust zweier Bytes
         ; die fehlerfreie Fortsetzung der Datenbearbeitung

bug      addq      #1,a0          ; Fehlerzhler inkrementieren
bug1     lsr       #1,d1
         bsr       bit
         cmpi      #15,d5
         bne.s     setz_nicht
         bset      #15,d1
setz_nicht move    d1,d5
         ori       #$1fc3,d5
         cmpi      #$ffdf,d5
         bne       bug1
         lsr       #6,d1
         andi      #$7f,d1

nobug    eor.b     d1,d7          ; Checksumme aktualisieren
         cmpi      #3,d1          ; ETX ?
         beq       ende
         cmpi      #$d,d1
         beq.s     vorschub
         movem.l   a1-a0/d3-d0,-(a7) ; zur Textausgabe sichern
         movea.l   prtoffs(pc),a1    ; Offset fr Druckposition in Zeile
         adda.l    line(pc),a1       ; + Zeilenadresse = Druckposition
         movea.l   anfscan(pc),a0    ; Anfang des Zeichensatzes
         adda      d1,a0             ; + ASCII = 1. Scanbyte des Zeichens
         moveq     #15,d0            ; 16 Scanbytes
         move      #$100,d2          ; 256 Zeichen / Zeichensatz
         move      #80,d3            ; 80 Bytes/Bildschirmlinie
copyscan move.b    (a0),(a1)         ; Scanbyte -> Bildschirm
         adda      d2,a0             ; Zeiger auf nchstes Scanbyte
         adda      d3,a1             ; Zeiger auf nchstes Bildschirmbyte
         dbra      d0,copyscan
         addq.l    #1,prtoffs        ; nchste Cursor-Position
         movem.l   (sp)+,d0-d3/a0-a1 ; Register restaurieren

         move.b    d1,(a5)+
         bra       basic

vorschub move.b    d1,(a5)+       ; dann CR ausgeben
         move.b    #$a,(a5)+      ; und LF hinzufgen

         ; Bildschirm-Pointer um 5*256 Bytes nach oben verschieben
         ; als Ersatz fr Linefeed

         movem.l   a0/d1-d0,-(sp) ; Register sichern
         clr.l     prtoffs        ; Zeiger auf Zeilenanfang
         move.l    $44e,d0        ; alten Pointer auslesen
         move.l    #1280,d1
         add.l     d1,d0          ; 5*256 Bytes
         add.l     d1,line        ; Zeilenadresse aktualisieren
         cmp.l     vlog(pc),d0    ; alte VRAM-Adresse erreicht ?
         bcs.s     enough         ; nein, noch ausreichend Speicher da
         move.l    #128000,d1     ; 128000 Bytes abziehen
         sub.l     d1,d0          ; 128000 Bytes abziehen
         sub.l     d1,line        ; 128 K abziehen
enough   move.l    d0,$44e        ; logical screenbase
         lsr.l     #8,d0
         movea.l   #$ff8200,a0
         movep     d0,1(a0)       ; Neue Adresse -> VDP
         movem.l   (sp)+,d0-d1/a0 ; fertig!
         bra       basic


         ; Byte montiert ein Byte d1 aus:
         ;                1 Startbit (logisch 0, 1200 Hz)
         ;                8 Datenbits (LSB zuerst)
         ;                2 Stoppbits (logisch 1, 2400 Hz)
         ;

byte     bsr       bit
         tst       d5             ; Startbit ?
         bne.s     bytefehler
         moveq     #6,d2          ; 7 Datenbits
         clr       d1
byte1    bsr       bit
         cmpi      #1,d5
         beq.s     byteend        ; Bitfehler -> Abbruch
         lsr.b     #1,d1
         tst       d5
         beq.s     noset
         bset      #6,d1
noset    dbra      d2,byte1
         moveq     #2,d2          ; Bit 7 wird hier den Stoppbits
stoppbit bsr       bit            ; zugeschlagen, da es immer gesetzt ist.
         cmpi      #15,d5
         bne.s     bytefehler
         dbra      d2,stoppbit
byteend  rts


bytefehler lea      byteftext(pc),a6
         movem.l   a0/d2-d1,-(sp)
         movea     prtoffs(pc),a0
         adda.l    line(pc),a0    ; Bildschirm-Ausgabeadresse
         moveq     #-1,d1         ; soll auf den Bildschirm
         moveq     #80,d2         ; Differenz zwischen den Augabebytes
         moveq.l    #15,d0
inram    move.b    (a6)+,(a5)+    ; "Bytefehler" in die Datei schreiben
         move.b    d1,(a0)        ; _ auf den Bildschirm
         adda      d2,a0          ; nchste Bildschirmadresse
         dbra      d0,inram
         addq.l    #1,prtoffs     ; auf die nchste Cursorposition
         movem.l   (sp)+,d1-d2/a0 ; Register restaurieren
         moveq     #1,d5
         rts


         ; Hole ein Bit von CTS
         ; Rckgabewert d5 : 15 fr 2400 Hz, 0 fr 1200 Hz
bit      clr       d3             ; Flag fr Schleifenwiederholung bei
                                  ; 2400 Hz
bit2     move      (a1),d5
         andi      #4,d5          ; CTS maskieren
         cmp       d5,d6
         beq       bit2
         clr       d6
         btst      #2,d5
         beq.s     sound1
         moveq     #15,d6
sound1   move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; Bit-Register aktualisieren
         clr       d4             ; Timer zurcksetzen
bit1     move      (a1),d5
         andi      #4,d5
         addq      #1,d4
         cmp       d5,d6
         beq.s     bit1           ; wenn Flanke dieselbe, dann wiederholen
         clr       d6
         btst      #2,d5
         beq.s     sound2
         moveq     #15,d6
sound2   move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; alten Flankenwert sichern
         clr       d5             ; Rckgaberegister fr Frequenzhhe
         cmpi      #65,d4          ; 1200 Hz ?
         bcc.s     hz1200
         moveq     #15,d5         ; Frequenz = 2400 Hz
         tst       d3             ; schon eine Schleife gedreht ?
         bne.s     hz1200
         moveq     #1,d3          ; Flag setzen
         bra       bit2
hz1200   rts



ende     bsr       altvekt
         exg       d7,a0          ; Checksumme <-> Fehlerzhler
         tst       d7
         bne.s     free_int       ; Fehler aufgetreten -> Checksumme berflssig.
         bsr       byte           ; Prfsumme holen
         cmpi      #1,d5
         beq.s     chkerror
         sub       a0,d1
         beq.s     free_int       ; Checksumme stimmt
chkerror pea       chkerrtxt(pc)  ; Fehlermeldung Checksummen-Error
         move      #9,-(sp)       ; ausgeben
         trap      #1
         addq.l    #6,sp
free_int eori      #$400,sr       ; Interrupts zulassen


         ; Anzahl der Fehler ausgeben
         pea       anzmel1(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp

         move.l    #10000,d1
teile1   divs      d1,d7
         tst       d7
         bne.s     foundnz
         swap      d7
         divs      #10,d1
         bne       teile1

foundnz  add       #$30,d7
         move      d7,-(sp)
         move      #2,-(sp)
         trap      #1
         addq.l    #4,sp
         clr       d7
         swap      d7
         tst       d1
         beq.s     nosign
         divs      #10,d1
         beq.s     nosign
         divs      d1,d7
         bra       foundnz

nosign   pea       anzmel2(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp


         ; Laufwerk A anwhlen
         clr       -(sp)
         move      #$0e,-(sp)     ; SETDRV
         trap      #1
         addq.l    #4,sp



         ; Datei anmelden
         clr.w     -(sp)          ; R/W-Datei
         lea       buffer(pc),a6
         addq.l    #2,a6
         move.l    a6,-(sp)
         move      #$3c,-(sp)
         trap      #1
         adda.l    #8,sp
         tst       d0
         bmi       disk_error


         ; Datei schreiben
         lea       beginn(pc),a0  ; Startadresse in
         move.l    (a0),d1        ; d1
         suba.l    d1,a5
         move.l    d1,-(sp)       ; Start
         move.l    a5,-(sp)       ; Lnge
         move      d0,-(sp)       ; Handle
         move      #$40,-(sp)
         trap      #1
         adda.l    #12,sp
         tst       d0
         bmi       disk_error


         ; Video-RAM wieder an ursprngliche Stelle bringen
end2     move.l    savessp(pc),d0
         move.l    d0,-(sp)       ; User-Modus einschalten
         move      #$20,-(sp)
         trap      #1
         addq.l    #6,sp
         clr.w     -(sp)          ; zurck zum Desktop
         trap      #1

disk_error  lea     detext(pc),a0
         bsr       ausgabe
         bra       end2

ausgabe  move.l    a0,-(sp)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         move      #$ffff,d0
warte    dbra      d0,warte
         rts

abbruch  eori      #$400,sr
         bsr       altvekt
         bra       end2

altvekt  move.l    vram(pc),d0    ; Bildschirm restaurieren:
         move.l    d0,$ff8200     ; Hardware-
         move.l    vlog(pc),$44e  ; und Software-Adresse
         rts

         data
byteftext  dc.b      ' @ Bytefehler @ '
cls        dc.b      $1b,'E',0
chkerrtxt  dc.b      'Checksummen-Fehler, ansonsten alles O.K.',$d,$a,0
anzmel1    dc.b      'Das eingelesene Programm enthlt ',0
anzmel2    dc.b      ' Fehler.',$d,$a,0
dat_ask    dc.b      $1b,'c1',$1b,'b0',$1b,'E'
           dc.b      'BASICODE-Konverter fr Atari ST  (November 1988)',$d,$a
           dc.b      '-------------------------------',$d,$a,$a
           dc.b      'Autor: Thomas Murer, Duisburger Str. 296, D-4200 Oberhausen 1',$d,$a,$a,$a
           dc.b      'Hardware-Voraussetzung: Direkte Verbindung der Pins 5 und 7 der Modem-',$d,$a
           dc.b      'Schnittstelle des Atari ST mit dem Lautsprecher-Ausgang eines Casset-',$d,$a
           dc.b      'tenrecorders/Verstrkers',$d,$a,$a,$a
           dc.b      'Namen der BASIC-Datei (mit Extender) eingeben ',$d,$a
           dc.b      '(BASICODE = Default, am besten nur RETURN drcken) :',$d,$a,0
buffer     dc.b      12,0,'basicode.bas',0
nstext     dc.b      'Nicht gengend Speicher vorhanden !',$d,$a,0
detext     dc.b      'Disk-Error !',$d,$a,0
meldung    dc.b      $d,$a,$a,'Damit die Signale schn rechteckig ankommen, bitte die Lautstrke',$d,$a
           dc.b      'am Cassettenrecorder bzw. Verstrker recht gro whlen, auerdem die',$d,$a
           dc.b      'Hhen in Mittelstellung und Bsse wegdrehen.',$d,$a
           dc.b      'Bei einstellbaren Verstrkern empfiehlt es sich, diese so einzu-',$d,$a
           dc.b      'stellen , da die PEAK-Anzeige des Verstrkers beim Einlesen des',$d,$a
           dc.b      'Programmes gerade immer aufleuchtet (Aussteuerungs-Anzeige auf +3 dB)!',$d,$a
           dc.b      'Nun die Starttaste des Recorders drcken !',$d,$a
           dc.b      'Vergi bitte nicht, eine beschreibbare Diskette in das Laufwerk A',$d,$a
           dc.b      'einzulegen (Du mchtest doch schlielich BASICODE nicht nur einlesen) !',$d,$a
           dc.b      'Wenn nun alles korrekt eingestellt ist, mu sofort nach dem Header-Ton',$d,$a
           dc.b      'dieser Text verschwinden. Stehen hinterher in der BASIC-Datei zu viele',$d,$a
           dc.b      'Bytefehler (das Programm arbeitet selbstkorrigierend, aber ein bis zwei Bytes',$d,$a
           dc.b      'gehen natrlich bei bertragungsfehlern verloren !), so ist entweder die Ein-',$d,$a
           dc.b      'stellung des Verstrkers (Hhen, Bsse, Lautstrke) falsch gewhlt oder',$d,$a
           dc.b      'die Aufnahmequalitt zu schlecht (starke Lautstrkeschwankungen beim Empfang',$d,$a
           dc.b      '= Fading, Gleichlaufschwankungen des Wiedergabegertes, Brummspannungen, etc.).',$d,$a,$a,$a,0


         bss

anfscan  ds.l      1
line     ds.l      1
prtoffs  ds.l      1
savessp  ds.l      1
counter  ds.w      1
ram_count ds.l     1
vram     ds.l      1   ; Hardware-Sicherungsregister
vlog     ds.l      1   ; Software-Sicherungsregister
beginn    ds.l     1

         end
 