         ; Programm zum Einlesen von BASICODE in ein BASIC-Programm

         text

         lea       beginn(pc),a5   ; RAM-Counter
         adda.l    #$100,a5        ; passend machen fr VDP
         move.l    a5,d0
         andi.l    #$ffffff00,d0
         movea.l   d0,a5

         ; Dateinamen erfragen
         pea       dat_ask(pc)     ; Frage ausgeben
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         pea       buffer(pc)     ; Eingabe des Dateinamens
         move      #$0a,-(sp)
         trap      #1             ; Nun befindet ab der Adresse buffer+2 der Name
         addq.l    #6,sp          ; der Datei
         tst       d0             ; Eingabe erfolgt ?
         beq       nochar
         lea       buffer(pc),a0  ;   Wenn ja,
         addq.l    #2,a0          ;   dann
         adda.l    d0,a0          ;   Abschlumarke
         clr.b     (a0)           ;   setzen.

         ; Meldung ausgeben

nochar   pea       meldung(pc)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp





         clr.l     -(sp)          ; Supervisormodus einschalten
         move      #$20,-(sp)
         trap      #1
         addq.l    #6,sp
         movea.l   d0,a2          ; alten Stack sichern
         ori       #$700,sr       ; Frequenz auf Kanal A einstellen:
         lea       $ff8800,a3     ; PSGA
         lea       $ff8802,a4     ; PSGD
         clr.b     (a3)           ; Frequenz maximal
         clr.b     (a4)
         move.b    #7,(a3)        ; Rauschen aus
         move.b    (a3),d0        ; alte Registerdaten auslesen,
         ori       #$3f,d0        ; ndern
         eori      #$1,d0         ; und
         move.b    d0,(a4)        ; zurckschreiben
         move.b    #8,(a3)        ; Lautstrke-Register anwhlen
         lea       $fffa00,a1     ; I/O-Port



anfang   move      #1000,d2       ; Header suchen
header   bsr       bit
         cmpi      #15,d5
         bne       anfang
         dbra      d2,header
lowsuch  bsr       bit            ; 2 Low Bits suchen
         tst       d5
         bne       lowsuch
         bsr       bit
         tst       d5
         bne       anfang
         bsr       bit            ; 1 High-Bit
         cmpi      #15,d5
         bne       anfang
         moveq     #4,d2
low      bsr       bit            ; 5 Low-Bits
         tst       d5
         bne       anfang
         dbra      d2,low
         moveq     #2,d2          ; 3 High-Bits
high     bsr       bit
         cmpi      #15,d5
         bne       anfang
         dbra      d2,high

         ; Nun kommt endlich der eigentliche BASIC-Text

         lea       vram(pc),a0    ; alte Adresse des VRAM sichern
         move.l    $ff8200,(a0)
         move.l    a5,d0
         andi.l    #$00ff0000,d0  ; Highbyte selektieren
         move.l    a5,d1
         lsr.w     #8,d1
         andi.l    #$ff,d1        ; Midbyte selektieren
         add.l     d0,d1
         lea       $ff8200,a0     ; Lage des Bildschirmspeichers
         move.l    d1,(a0)        ; neu definieren

basic    bsr       byte
         cmpi      #1,d5          ; Fehler aufgetreten ?
         bne       nobug




         ; Fehlerbehandlung ermglicht unter Verlust zweier Bytes
         ; die fehlerfreie Fortsetzung der Datenbertragung

bug      lsr       #1,d1
         bsr       bit
         cmpi      #15,d5
         bne       setz_nicht
         bset      #15,d1
setz_nicht move    d1,d5
         ori       #$1fc3,d5
         cmpi      #$ffdf,d5
         bne       bug
         lsr       #6,d1
         andi      #$7f,d1



nobug    cmpi      #3,d1          ; ETX ?
         beq       ende

         cmpi      #$d,d1         ; CR ?
         bne       btoram
         move.b    d1,(a5)+       ; dann CR ausgeben
         moveq     #$a,d1         ; und LF hinzufgen
btoram   move.b    d1,(a5)+
         bra       basic






         bra       ende


         ; Byte montiert ein Byte d1 aus:
         ;                1 Startbit (logisch 0, 1200 Hz)
         ;                8 Datenbits (LSB zuerst)
         ;                2 Stoppbits (logisch 1, 2400 Hz)
         ;

byte     bsr       bit
         tst       d5             ; Startbit ?
         bne       bytefehler
         moveq     #6,d2          ; 7 Datenbits
         clr       d1
byte1    bsr       bit
         cmpi      #1,d5
         beq       byteend        ; Bitfehler -> Abbruch
         lsr.b     #1,d1
         tst       d5
         beq       noset
         bset      #6,d1
noset    dbra      d2,byte1
         moveq     #2,d2          ; Bit 7 wird hier den Stoppbits
stoppbit bsr       bit            ; zugeschlagen, da es immer gesetzt ist.
         cmpi      #15,d5
         bne       bytefehler
         dbra      d2,stoppbit
byteend  rts


bytefehler lea      byteftext(pc),a6
         moveq.l    #15,d0
inram    move.b    (a6)+,(a5)+
         dbra      d0,inram
         moveq     #1,d5
         rts






         ; Hole ein Bit von CTS
         ; Rckgabewert d5 : 15 fr 2400 Hz, 0 fr 1200 Hz
bit      clr       d3             ; Flag fr Schleifenwiederholung bei
                                  ; 2400 Hz
         move      (a1),d6        ; Port auslesen
         andi      #4,d6          ; CTS maskieren
bit2     move      (a1),d5
         andi      #4,d5          ; CTS maskieren
         cmp       d5,d6
         beq       bit2
         clr       d6
         btst      #2,d5
         beq       sound1
         moveq     #15,d6
sound1   move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; Bit-Register aktualisieren
         clr       d4             ; Timer zurcksetzen
bit1     move      (a1),d5
         andi      #4,d5
         addq      #1,d4
         cmp       d5,d6
         beq.s     bit1           ; wenn Flanke dieselbe, dann wiederholen
         clr       d6
         btst      #2,d5
         beq       sound2
         moveq     #15,d6
sound2   move.b    d6,(a4)        ; Flanke als Lautstrke ausgeben
         move      d5,d6          ; alten Flankenwert sichern
         clr       d5             ; Rckgaberegister fr Frequenzhhe
         cmpi      #65,d4          ; 1200 Hz ?
         bcc       hz1200
         move      #15,d5         ; Frequenz = 2400 Hz
         tst       d3             ; schon eine Schleife gedreht ?
         bne       hz1200
         moveq     #1,d3          ; Flag setzen
         bra       bit2
hz1200   rts


ende     eori      #$400,sr       ; Interrupts zulassen

         ; Laufwerk A anwhlen
         clr       -(sp)
         move      #$0e,-(sp)     ; SETDRV
         trap      #1
         addq.l    #4,sp



         ; Datei anmelden
         clr.w     -(sp)          ; R/W-Datei
         lea       buffer(pc),a6
         addq.l    #2,a6
         move.l    a6,-(sp)
         move      #$3c,-(sp)
         trap      #1
         adda.l    #8,sp
         tst       d0
         bmi       disk_error


         ; Datei schreiben
         lea       beginn(pc),a0
         suba.l    a0,a5
         pea       beginn(pc)     ; Start
         move.l    a5,-(sp)       ; Lnge
         move      d0,-(sp)       ; Handle
         move      #$40,-(sp)
         trap      #1
         adda.l    #12,sp
         tst       d0
         bmi       disk_error


         ; Video-RAM wieder an ursprngliche Stelle bringen
end1     move.l    vram(pc),d0
         move.l    d0,$ff8200

end2     move.l    a2,-(sp)       ; User-Modus einschalten
         move      #$20,-(sp)
         trap      #1
         addq.l    #6,sp
         clr.w     -(sp)          ; zurck zum Desktop
         trap      #1

no_space lea       nstext(pc),a0
         bsr       ausgabe
         bra       end1

disk_error move.l  vram(pc),d0
         move.l    d0,$ff8200
         lea     detext(pc),a0
         bsr       ausgabe
         bra       end2

ausgabe  move.l    a0,-(sp)
         move      #9,-(sp)
         trap      #1
         addq.l    #6,sp
         move      #$ffff,d0
warte    dbra      d0,warte
         rts




         data
bitftext   dc.b      'Bitfehler !!!     ->    Abbruch',$d,$a,0
byteftext  dc.b      ' ',$af,' Bytefehler ',$ae,' '
dat_ask    dc.b      $1b,'E',$1b,'p'
           dc.b      'BASICODE-Konverter fr Atari ST  (Oktober 1988)',$d,$a
           dc.b      '-------------------------------',$d,$a,$a
           dc.b      'Autor: Thomas Murer, Duisburger Str. 296, D-4200 Oberhausen 1',$d,$a,$a,$a
           dc.b      'Hardware-Voraussetzung: Direkte Verbindung der Pins 5 und 7 der Modem-',$d,$a
           dc.b      'Schnittstelle des Atari ST mit dem Lautsprecher-Ausgang eines Casset-',$d,$a
           dc.b      'tenrecorders/Verstrkers',$d,$a,$a,$a
           dc.b      'Namen der BASIC-Datei (ohne Extender) eingeben ',$d,$a
           dc.b      '(BASICODE = Default, am besten nur RETURN drcken) :',$d,$a,0
buffer     dc.b      8,0,'basicode.bas',0
nstext     dc.b      'Nicht gengend Speicher vorhanden !',$d,$a,0
detext     dc.b      'Disk-Error !',$d,$a,0
meldung    dc.b      'Damit die Signale schn rechteckig ankommen, bitte die Lautstrke',$d,$a
           dc.b      'am Cassettenrecorder bzw. Verstrker recht gro whlen, auerdem die',$d,$a
           dc.b      'Hhen in Mittelstellung und Bsse wegdrehen.',$d,$a
           dc.b      'Bei einstellbaren Verstrkern empfiehlt es sich, diese so einzu-',$d,$a
           dc.b      'stellen , da die PEAK-Anzeige des Verstrkers beim Einlesen des',$d,$a
           dc.b      'Programmes gerade immer aufleuchtet (Aussteuerungs-Anzeige auf +3 dB)!',$d,$a
           dc.b      'Nun die Starttaste des Recorders drcken !',$d,$a
           dc.b      'Vergi bitte nicht, eine beschreibbare Diskette in das Laufwerk A',$d,$a
           dc.b      'einzulegen (Du mchtest doch schlielich BASICODE nicht nur einlesen) !',$d,$a
           dc.b      'Wenn nun alles korrekt eingestellt ist, mu sofort nach dem Header-Ton',$d,$a
           dc.b      'dieser Text verschwinden. Stehen hinterher in der BASIC-Datei zu viele',$d,$a
           dc.b      'Bytefehler (das Programm arbeitet selbstkorrigierend, aber ein bis zwei Bytes',$d,$a
           dc.b      'gehen natrlich bei bertragungsfehlern verloren !), so ist entweder die Ein-',$d,$a
           dc.b      'stellung des Verstrkers (Hhen, Bsse, Lautstrke) falsch gewhlt oder',$d,$a
           dc.b      'die Aufnahmequalitt zu schlecht (starke Lautstrkeschwankungen beim Empfang',$d,$a
           dc.b      '= Fading, Gleichlaufschwankungen des Wiedergabegertes, Brummspannungen, etc.).',$d,$a,0


         bss
counter  ds.w      1
ram_count ds.l     1
vram     ds.l      1
beginn    ds.l     1

         end
 